package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{
  SshPublicKeyId,
  SshPublicKeyBody,
  DateImported
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class SshPublicKey(
    dateImported: DateImported,
    sshPublicKeyBody: SshPublicKeyBody,
    sshPublicKeyId: SshPublicKeyId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.SshPublicKey = {
    import SshPublicKey.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.SshPublicKey
      .builder()
      .dateImported(DateImported.unwrap(dateImported): Instant)
      .sshPublicKeyBody(
        SshPublicKeyBody.unwrap(sshPublicKeyBody): java.lang.String
      )
      .sshPublicKeyId(SshPublicKeyId.unwrap(sshPublicKeyId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.SshPublicKey.ReadOnly =
    zio.aws.transfer.model.SshPublicKey.wrap(buildAwsValue())
}
object SshPublicKey {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.SshPublicKey
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.SshPublicKey = zio.aws.transfer.model
      .SshPublicKey(dateImported, sshPublicKeyBody, sshPublicKeyId)
    def dateImported: DateImported
    def sshPublicKeyBody: SshPublicKeyBody
    def sshPublicKeyId: SshPublicKeyId
    def getDateImported: ZIO[Any, Nothing, DateImported] =
      ZIO.succeed(dateImported)
    def getSshPublicKeyBody: ZIO[Any, Nothing, SshPublicKeyBody] =
      ZIO.succeed(sshPublicKeyBody)
    def getSshPublicKeyId: ZIO[Any, Nothing, SshPublicKeyId] =
      ZIO.succeed(sshPublicKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.SshPublicKey
  ) extends zio.aws.transfer.model.SshPublicKey.ReadOnly {
    override val dateImported: DateImported =
      zio.aws.transfer.model.primitives.DateImported(impl.dateImported())
    override val sshPublicKeyBody: SshPublicKeyBody =
      zio.aws.transfer.model.primitives
        .SshPublicKeyBody(impl.sshPublicKeyBody())
    override val sshPublicKeyId: SshPublicKeyId =
      zio.aws.transfer.model.primitives.SshPublicKeyId(impl.sshPublicKeyId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.SshPublicKey
  ): zio.aws.transfer.model.SshPublicKey.ReadOnly = new Wrapper(impl)
}
