package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{TagValue, TagKey}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class Tag(key: TagKey, value: TagValue) {
  def buildAwsValue(): software.amazon.awssdk.services.transfer.model.Tag = {
    import Tag.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.Tag
      .builder()
      .key(TagKey.unwrap(key): java.lang.String)
      .value(TagValue.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.Tag.ReadOnly =
    zio.aws.transfer.model.Tag.wrap(buildAwsValue())
}
object Tag {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.transfer.model.Tag] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.Tag =
      zio.aws.transfer.model.Tag(key, value)
    def key: TagKey
    def value: TagValue
    def getKey: ZIO[Any, Nothing, TagKey] = ZIO.succeed(key)
    def getValue: ZIO[Any, Nothing, TagValue] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.Tag
  ) extends zio.aws.transfer.model.Tag.ReadOnly {
    override val key: TagKey =
      zio.aws.transfer.model.primitives.TagKey(impl.key())
    override val value: TagValue =
      zio.aws.transfer.model.primitives.TagValue(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.Tag
  ): zio.aws.transfer.model.Tag.ReadOnly = new Wrapper(impl)
}
