package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{
  UserPassword,
  UserName,
  SourceIp,
  ServerId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TestIdentityProviderRequest(
    serverId: ServerId,
    serverProtocol: Optional[zio.aws.transfer.model.Protocol] = Optional.Absent,
    sourceIp: Optional[SourceIp] = Optional.Absent,
    userName: UserName,
    userPassword: Optional[UserPassword] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.TestIdentityProviderRequest = {
    import TestIdentityProviderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.TestIdentityProviderRequest
      .builder()
      .serverId(ServerId.unwrap(serverId): java.lang.String)
      .optionallyWith(serverProtocol.map(value => value.unwrap))(
        _.serverProtocol
      )
      .optionallyWith(
        sourceIp.map(value => SourceIp.unwrap(value): java.lang.String)
      )(_.sourceIp)
      .userName(UserName.unwrap(userName): java.lang.String)
      .optionallyWith(
        userPassword.map(value => UserPassword.unwrap(value): java.lang.String)
      )(_.userPassword)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.TestIdentityProviderRequest.ReadOnly =
    zio.aws.transfer.model.TestIdentityProviderRequest.wrap(buildAwsValue())
}
object TestIdentityProviderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.TestIdentityProviderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.TestIdentityProviderRequest =
      zio.aws.transfer.model.TestIdentityProviderRequest(
        serverId,
        serverProtocol.map(value => value),
        sourceIp.map(value => value),
        userName,
        userPassword.map(value => value)
      )
    def serverId: ServerId
    def serverProtocol: Optional[zio.aws.transfer.model.Protocol]
    def sourceIp: Optional[SourceIp]
    def userName: UserName
    def userPassword: Optional[UserPassword]
    def getServerId: ZIO[Any, Nothing, ServerId] = ZIO.succeed(serverId)
    def getServerProtocol: ZIO[Any, AwsError, zio.aws.transfer.model.Protocol] =
      AwsError.unwrapOptionField("serverProtocol", serverProtocol)
    def getSourceIp: ZIO[Any, AwsError, SourceIp] =
      AwsError.unwrapOptionField("sourceIp", sourceIp)
    def getUserName: ZIO[Any, Nothing, UserName] = ZIO.succeed(userName)
    def getUserPassword: ZIO[Any, AwsError, UserPassword] =
      AwsError.unwrapOptionField("userPassword", userPassword)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.TestIdentityProviderRequest
  ) extends zio.aws.transfer.model.TestIdentityProviderRequest.ReadOnly {
    override val serverId: ServerId =
      zio.aws.transfer.model.primitives.ServerId(impl.serverId())
    override val serverProtocol: Optional[zio.aws.transfer.model.Protocol] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serverProtocol())
        .map(value => zio.aws.transfer.model.Protocol.wrap(value))
    override val sourceIp: Optional[SourceIp] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceIp())
      .map(value => zio.aws.transfer.model.primitives.SourceIp(value))
    override val userName: UserName =
      zio.aws.transfer.model.primitives.UserName(impl.userName())
    override val userPassword: Optional[UserPassword] = zio.aws.core.internal
      .optionalFromNullable(impl.userPassword())
      .map(value => zio.aws.transfer.model.primitives.UserPassword(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.TestIdentityProviderRequest
  ): zio.aws.transfer.model.TestIdentityProviderRequest.ReadOnly = new Wrapper(
    impl
  )
}
