package zio.aws.transfer.model
import scala.jdk.CollectionConverters._
sealed trait TlsSessionResumptionMode {
  def unwrap
      : software.amazon.awssdk.services.transfer.model.TlsSessionResumptionMode
}
object TlsSessionResumptionMode {
  def wrap(
      value: software.amazon.awssdk.services.transfer.model.TlsSessionResumptionMode
  ): zio.aws.transfer.model.TlsSessionResumptionMode = value match {
    case software.amazon.awssdk.services.transfer.model.TlsSessionResumptionMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.transfer.model.TlsSessionResumptionMode.DISABLED =>
      val r = DISABLED
      r
    case software.amazon.awssdk.services.transfer.model.TlsSessionResumptionMode.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.transfer.model.TlsSessionResumptionMode.ENFORCED =>
      val r = ENFORCED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.transfer.model.TlsSessionResumptionMode {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.TlsSessionResumptionMode =
      software.amazon.awssdk.services.transfer.model.TlsSessionResumptionMode.UNKNOWN_TO_SDK_VERSION
  }
  case object DISABLED extends zio.aws.transfer.model.TlsSessionResumptionMode {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.TlsSessionResumptionMode =
      software.amazon.awssdk.services.transfer.model.TlsSessionResumptionMode.DISABLED
  }
  case object ENABLED extends zio.aws.transfer.model.TlsSessionResumptionMode {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.TlsSessionResumptionMode =
      software.amazon.awssdk.services.transfer.model.TlsSessionResumptionMode.ENABLED
  }
  case object ENFORCED extends zio.aws.transfer.model.TlsSessionResumptionMode {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.TlsSessionResumptionMode =
      software.amazon.awssdk.services.transfer.model.TlsSessionResumptionMode.ENFORCED
  }
}
