package zio.aws.transfer.model
import scala.jdk.CollectionConverters._
sealed trait As2Transport {
  def unwrap: software.amazon.awssdk.services.transfer.model.As2Transport
}
object As2Transport {
  def wrap(
      value: software.amazon.awssdk.services.transfer.model.As2Transport
  ): zio.aws.transfer.model.As2Transport = value match {
    case software.amazon.awssdk.services.transfer.model.As2Transport.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.transfer.model.As2Transport.HTTP =>
      val r = HTTP
      r
  }
  case object unknownToSdkVersion extends zio.aws.transfer.model.As2Transport {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.As2Transport =
      software.amazon.awssdk.services.transfer.model.As2Transport.UNKNOWN_TO_SDK_VERSION
  }
  case object HTTP extends zio.aws.transfer.model.As2Transport {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.As2Transport =
      software.amazon.awssdk.services.transfer.model.As2Transport.HTTP
  }
}
