package zio.aws.transfer.model
import scala.jdk.CollectionConverters._
sealed trait CertificateUsageType {
  def unwrap
      : software.amazon.awssdk.services.transfer.model.CertificateUsageType
}
object CertificateUsageType {
  def wrap(
      value: software.amazon.awssdk.services.transfer.model.CertificateUsageType
  ): zio.aws.transfer.model.CertificateUsageType = value match {
    case software.amazon.awssdk.services.transfer.model.CertificateUsageType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.transfer.model.CertificateUsageType.SIGNING =>
      val r = SIGNING
      r
    case software.amazon.awssdk.services.transfer.model.CertificateUsageType.ENCRYPTION =>
      val r = ENCRYPTION
      r
    case software.amazon.awssdk.services.transfer.model.CertificateUsageType.TLS =>
      val r = TLS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.transfer.model.CertificateUsageType {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.CertificateUsageType =
      software.amazon.awssdk.services.transfer.model.CertificateUsageType.UNKNOWN_TO_SDK_VERSION
  }
  case object SIGNING extends zio.aws.transfer.model.CertificateUsageType {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.CertificateUsageType =
      software.amazon.awssdk.services.transfer.model.CertificateUsageType.SIGNING
  }
  case object ENCRYPTION extends zio.aws.transfer.model.CertificateUsageType {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.CertificateUsageType =
      software.amazon.awssdk.services.transfer.model.CertificateUsageType.ENCRYPTION
  }
  case object TLS extends zio.aws.transfer.model.CertificateUsageType {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.CertificateUsageType =
      software.amazon.awssdk.services.transfer.model.CertificateUsageType.TLS
  }
}
