package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{SourceFileLocation, WorkflowStepName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CopyStepDetails(
    name: Optional[WorkflowStepName] = Optional.Absent,
    destinationFileLocation: Optional[
      zio.aws.transfer.model.InputFileLocation
    ] = Optional.Absent,
    overwriteExisting: Optional[zio.aws.transfer.model.OverwriteExisting] =
      Optional.Absent,
    sourceFileLocation: Optional[SourceFileLocation] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.CopyStepDetails = {
    import CopyStepDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.CopyStepDetails
      .builder()
      .optionallyWith(
        name.map(value => WorkflowStepName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        destinationFileLocation.map(value => value.buildAwsValue())
      )(_.destinationFileLocation)
      .optionallyWith(overwriteExisting.map(value => value.unwrap))(
        _.overwriteExisting
      )
      .optionallyWith(
        sourceFileLocation.map(value =>
          SourceFileLocation.unwrap(value): java.lang.String
        )
      )(_.sourceFileLocation)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.CopyStepDetails.ReadOnly =
    zio.aws.transfer.model.CopyStepDetails.wrap(buildAwsValue())
}
object CopyStepDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.CopyStepDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.CopyStepDetails =
      zio.aws.transfer.model.CopyStepDetails(
        name.map(value => value),
        destinationFileLocation.map(value => value.asEditable),
        overwriteExisting.map(value => value),
        sourceFileLocation.map(value => value)
      )
    def name: Optional[WorkflowStepName]
    def destinationFileLocation
        : Optional[zio.aws.transfer.model.InputFileLocation.ReadOnly]
    def overwriteExisting: Optional[zio.aws.transfer.model.OverwriteExisting]
    def sourceFileLocation: Optional[SourceFileLocation]
    def getName: ZIO[Any, AwsError, WorkflowStepName] =
      AwsError.unwrapOptionField("name", name)
    def getDestinationFileLocation: ZIO[
      Any,
      AwsError,
      zio.aws.transfer.model.InputFileLocation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "destinationFileLocation",
      destinationFileLocation
    )
    def getOverwriteExisting
        : ZIO[Any, AwsError, zio.aws.transfer.model.OverwriteExisting] =
      AwsError.unwrapOptionField("overwriteExisting", overwriteExisting)
    def getSourceFileLocation: ZIO[Any, AwsError, SourceFileLocation] =
      AwsError.unwrapOptionField("sourceFileLocation", sourceFileLocation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.CopyStepDetails
  ) extends zio.aws.transfer.model.CopyStepDetails.ReadOnly {
    override val name: Optional[WorkflowStepName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.transfer.model.primitives.WorkflowStepName(value))
    override val destinationFileLocation
        : Optional[zio.aws.transfer.model.InputFileLocation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationFileLocation())
        .map(value => zio.aws.transfer.model.InputFileLocation.wrap(value))
    override val overwriteExisting
        : Optional[zio.aws.transfer.model.OverwriteExisting] =
      zio.aws.core.internal
        .optionalFromNullable(impl.overwriteExisting())
        .map(value => zio.aws.transfer.model.OverwriteExisting.wrap(value))
    override val sourceFileLocation: Optional[SourceFileLocation] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceFileLocation())
        .map(value =>
          zio.aws.transfer.model.primitives.SourceFileLocation(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.CopyStepDetails
  ): zio.aws.transfer.model.CopyStepDetails.ReadOnly = new Wrapper(impl)
}
