package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{
  ConnectorSecurityPolicyName,
  Role,
  Url
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateConnectorRequest(
    url: Url,
    as2Config: Optional[zio.aws.transfer.model.As2ConnectorConfig] =
      Optional.Absent,
    accessRole: Role,
    loggingRole: Optional[Role] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.transfer.model.Tag]] = Optional.Absent,
    sftpConfig: Optional[zio.aws.transfer.model.SftpConnectorConfig] =
      Optional.Absent,
    securityPolicyName: Optional[ConnectorSecurityPolicyName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.CreateConnectorRequest = {
    import CreateConnectorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.CreateConnectorRequest
      .builder()
      .url(Url.unwrap(url): java.lang.String)
      .optionallyWith(as2Config.map(value => value.buildAwsValue()))(
        _.as2Config
      )
      .accessRole(Role.unwrap(accessRole): java.lang.String)
      .optionallyWith(
        loggingRole.map(value => Role.unwrap(value): java.lang.String)
      )(_.loggingRole)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(sftpConfig.map(value => value.buildAwsValue()))(
        _.sftpConfig
      )
      .optionallyWith(
        securityPolicyName.map(value =>
          ConnectorSecurityPolicyName.unwrap(value): java.lang.String
        )
      )(_.securityPolicyName)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.CreateConnectorRequest.ReadOnly =
    zio.aws.transfer.model.CreateConnectorRequest.wrap(buildAwsValue())
}
object CreateConnectorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.CreateConnectorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.CreateConnectorRequest =
      zio.aws.transfer.model.CreateConnectorRequest(
        url,
        as2Config.map(value => value.asEditable),
        accessRole,
        loggingRole.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sftpConfig.map(value => value.asEditable),
        securityPolicyName.map(value => value)
      )
    def url: Url
    def as2Config: Optional[zio.aws.transfer.model.As2ConnectorConfig.ReadOnly]
    def accessRole: Role
    def loggingRole: Optional[Role]
    def tags: Optional[List[zio.aws.transfer.model.Tag.ReadOnly]]
    def sftpConfig
        : Optional[zio.aws.transfer.model.SftpConnectorConfig.ReadOnly]
    def securityPolicyName: Optional[ConnectorSecurityPolicyName]
    def getUrl: ZIO[Any, Nothing, Url] = ZIO.succeed(url)
    def getAs2Config: ZIO[
      Any,
      AwsError,
      zio.aws.transfer.model.As2ConnectorConfig.ReadOnly
    ] = AwsError.unwrapOptionField("as2Config", as2Config)
    def getAccessRole: ZIO[Any, Nothing, Role] = ZIO.succeed(accessRole)
    def getLoggingRole: ZIO[Any, AwsError, Role] =
      AwsError.unwrapOptionField("loggingRole", loggingRole)
    def getTags: ZIO[Any, AwsError, List[zio.aws.transfer.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getSftpConfig: ZIO[
      Any,
      AwsError,
      zio.aws.transfer.model.SftpConnectorConfig.ReadOnly
    ] = AwsError.unwrapOptionField("sftpConfig", sftpConfig)
    def getSecurityPolicyName: ZIO[Any, AwsError, ConnectorSecurityPolicyName] =
      AwsError.unwrapOptionField("securityPolicyName", securityPolicyName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.CreateConnectorRequest
  ) extends zio.aws.transfer.model.CreateConnectorRequest.ReadOnly {
    override val url: Url = zio.aws.transfer.model.primitives.Url(impl.url())
    override val as2Config
        : Optional[zio.aws.transfer.model.As2ConnectorConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.as2Config())
        .map(value => zio.aws.transfer.model.As2ConnectorConfig.wrap(value))
    override val accessRole: Role =
      zio.aws.transfer.model.primitives.Role(impl.accessRole())
    override val loggingRole: Optional[Role] = zio.aws.core.internal
      .optionalFromNullable(impl.loggingRole())
      .map(value => zio.aws.transfer.model.primitives.Role(value))
    override val tags: Optional[List[zio.aws.transfer.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.transfer.model.Tag.wrap(item)
          }.toList
        )
    override val sftpConfig
        : Optional[zio.aws.transfer.model.SftpConnectorConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sftpConfig())
        .map(value => zio.aws.transfer.model.SftpConnectorConfig.wrap(value))
    override val securityPolicyName: Optional[ConnectorSecurityPolicyName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityPolicyName())
        .map(value =>
          zio.aws.transfer.model.primitives.ConnectorSecurityPolicyName(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.CreateConnectorRequest
  ): zio.aws.transfer.model.CreateConnectorRequest.ReadOnly = new Wrapper(impl)
}
