package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{CertificateId, As2Id}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateProfileRequest(
    as2Id: As2Id,
    profileType: zio.aws.transfer.model.ProfileType,
    certificateIds: Optional[Iterable[CertificateId]] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.transfer.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.CreateProfileRequest = {
    import CreateProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.CreateProfileRequest
      .builder()
      .as2Id(As2Id.unwrap(as2Id): java.lang.String)
      .profileType(profileType.unwrap)
      .optionallyWith(
        certificateIds.map(value =>
          value.map { item =>
            CertificateId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.certificateIds)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.CreateProfileRequest.ReadOnly =
    zio.aws.transfer.model.CreateProfileRequest.wrap(buildAwsValue())
}
object CreateProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.CreateProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.CreateProfileRequest =
      zio.aws.transfer.model.CreateProfileRequest(
        as2Id,
        profileType,
        certificateIds.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def as2Id: As2Id
    def profileType: zio.aws.transfer.model.ProfileType
    def certificateIds: Optional[List[CertificateId]]
    def tags: Optional[List[zio.aws.transfer.model.Tag.ReadOnly]]
    def getAs2Id: ZIO[Any, Nothing, As2Id] = ZIO.succeed(as2Id)
    def getProfileType: ZIO[Any, Nothing, zio.aws.transfer.model.ProfileType] =
      ZIO.succeed(profileType)
    def getCertificateIds: ZIO[Any, AwsError, List[CertificateId]] =
      AwsError.unwrapOptionField("certificateIds", certificateIds)
    def getTags: ZIO[Any, AwsError, List[zio.aws.transfer.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.CreateProfileRequest
  ) extends zio.aws.transfer.model.CreateProfileRequest.ReadOnly {
    override val as2Id: As2Id =
      zio.aws.transfer.model.primitives.As2Id(impl.as2Id())
    override val profileType: zio.aws.transfer.model.ProfileType =
      zio.aws.transfer.model.ProfileType.wrap(impl.profileType())
    override val certificateIds: Optional[List[CertificateId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificateIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.transfer.model.primitives.CertificateId(item)
          }.toList
        )
    override val tags: Optional[List[zio.aws.transfer.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.transfer.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.CreateProfileRequest
  ): zio.aws.transfer.model.CreateProfileRequest.ReadOnly = new Wrapper(impl)
}
