package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.ProfileId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateProfileResponse(profileId: ProfileId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.CreateProfileResponse = {
    import CreateProfileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.CreateProfileResponse
      .builder()
      .profileId(ProfileId.unwrap(profileId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.CreateProfileResponse.ReadOnly =
    zio.aws.transfer.model.CreateProfileResponse.wrap(buildAwsValue())
}
object CreateProfileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.CreateProfileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.CreateProfileResponse =
      zio.aws.transfer.model.CreateProfileResponse(profileId)
    def profileId: ProfileId
    def getProfileId: ZIO[Any, Nothing, ProfileId] = ZIO.succeed(profileId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.CreateProfileResponse
  ) extends zio.aws.transfer.model.CreateProfileResponse.ReadOnly {
    override val profileId: ProfileId =
      zio.aws.transfer.model.primitives.ProfileId(impl.profileId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.CreateProfileResponse
  ): zio.aws.transfer.model.CreateProfileResponse.ReadOnly = new Wrapper(impl)
}
