package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{ServerId, AgreementId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteAgreementRequest(
    agreementId: AgreementId,
    serverId: ServerId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.DeleteAgreementRequest = {
    import DeleteAgreementRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.DeleteAgreementRequest
      .builder()
      .agreementId(AgreementId.unwrap(agreementId): java.lang.String)
      .serverId(ServerId.unwrap(serverId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.DeleteAgreementRequest.ReadOnly =
    zio.aws.transfer.model.DeleteAgreementRequest.wrap(buildAwsValue())
}
object DeleteAgreementRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.DeleteAgreementRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.DeleteAgreementRequest =
      zio.aws.transfer.model.DeleteAgreementRequest(agreementId, serverId)
    def agreementId: AgreementId
    def serverId: ServerId
    def getAgreementId: ZIO[Any, Nothing, AgreementId] =
      ZIO.succeed(agreementId)
    def getServerId: ZIO[Any, Nothing, ServerId] = ZIO.succeed(serverId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.DeleteAgreementRequest
  ) extends zio.aws.transfer.model.DeleteAgreementRequest.ReadOnly {
    override val agreementId: AgreementId =
      zio.aws.transfer.model.primitives.AgreementId(impl.agreementId())
    override val serverId: ServerId =
      zio.aws.transfer.model.primitives.ServerId(impl.serverId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.DeleteAgreementRequest
  ): zio.aws.transfer.model.DeleteAgreementRequest.ReadOnly = new Wrapper(impl)
}
