package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.CertificateId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteCertificateRequest(certificateId: CertificateId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.DeleteCertificateRequest = {
    import DeleteCertificateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.DeleteCertificateRequest
      .builder()
      .certificateId(CertificateId.unwrap(certificateId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.DeleteCertificateRequest.ReadOnly =
    zio.aws.transfer.model.DeleteCertificateRequest.wrap(buildAwsValue())
}
object DeleteCertificateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.DeleteCertificateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.DeleteCertificateRequest =
      zio.aws.transfer.model.DeleteCertificateRequest(certificateId)
    def certificateId: CertificateId
    def getCertificateId: ZIO[Any, Nothing, CertificateId] =
      ZIO.succeed(certificateId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.DeleteCertificateRequest
  ) extends zio.aws.transfer.model.DeleteCertificateRequest.ReadOnly {
    override val certificateId: CertificateId =
      zio.aws.transfer.model.primitives.CertificateId(impl.certificateId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.DeleteCertificateRequest
  ): zio.aws.transfer.model.DeleteCertificateRequest.ReadOnly = new Wrapper(
    impl
  )
}
