package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.ProfileId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteProfileRequest(profileId: ProfileId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.DeleteProfileRequest = {
    import DeleteProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.DeleteProfileRequest
      .builder()
      .profileId(ProfileId.unwrap(profileId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.DeleteProfileRequest.ReadOnly =
    zio.aws.transfer.model.DeleteProfileRequest.wrap(buildAwsValue())
}
object DeleteProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.DeleteProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.DeleteProfileRequest =
      zio.aws.transfer.model.DeleteProfileRequest(profileId)
    def profileId: ProfileId
    def getProfileId: ZIO[Any, Nothing, ProfileId] = ZIO.succeed(profileId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.DeleteProfileRequest
  ) extends zio.aws.transfer.model.DeleteProfileRequest.ReadOnly {
    override val profileId: ProfileId =
      zio.aws.transfer.model.primitives.ProfileId(impl.profileId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.DeleteProfileRequest
  ): zio.aws.transfer.model.DeleteProfileRequest.ReadOnly = new Wrapper(impl)
}
