package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.ServerId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteServerRequest(serverId: ServerId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.DeleteServerRequest = {
    import DeleteServerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.DeleteServerRequest
      .builder()
      .serverId(ServerId.unwrap(serverId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.DeleteServerRequest.ReadOnly =
    zio.aws.transfer.model.DeleteServerRequest.wrap(buildAwsValue())
}
object DeleteServerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.DeleteServerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.DeleteServerRequest =
      zio.aws.transfer.model.DeleteServerRequest(serverId)
    def serverId: ServerId
    def getServerId: ZIO[Any, Nothing, ServerId] = ZIO.succeed(serverId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.DeleteServerRequest
  ) extends zio.aws.transfer.model.DeleteServerRequest.ReadOnly {
    override val serverId: ServerId =
      zio.aws.transfer.model.primitives.ServerId(impl.serverId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.DeleteServerRequest
  ): zio.aws.transfer.model.DeleteServerRequest.ReadOnly = new Wrapper(impl)
}
