package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{SourceFileLocation, WorkflowStepName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteStepDetails(
    name: Optional[WorkflowStepName] = Optional.Absent,
    sourceFileLocation: Optional[SourceFileLocation] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.DeleteStepDetails = {
    import DeleteStepDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.DeleteStepDetails
      .builder()
      .optionallyWith(
        name.map(value => WorkflowStepName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        sourceFileLocation.map(value =>
          SourceFileLocation.unwrap(value): java.lang.String
        )
      )(_.sourceFileLocation)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.DeleteStepDetails.ReadOnly =
    zio.aws.transfer.model.DeleteStepDetails.wrap(buildAwsValue())
}
object DeleteStepDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.DeleteStepDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.DeleteStepDetails =
      zio.aws.transfer.model.DeleteStepDetails(
        name.map(value => value),
        sourceFileLocation.map(value => value)
      )
    def name: Optional[WorkflowStepName]
    def sourceFileLocation: Optional[SourceFileLocation]
    def getName: ZIO[Any, AwsError, WorkflowStepName] =
      AwsError.unwrapOptionField("name", name)
    def getSourceFileLocation: ZIO[Any, AwsError, SourceFileLocation] =
      AwsError.unwrapOptionField("sourceFileLocation", sourceFileLocation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.DeleteStepDetails
  ) extends zio.aws.transfer.model.DeleteStepDetails.ReadOnly {
    override val name: Optional[WorkflowStepName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.transfer.model.primitives.WorkflowStepName(value))
    override val sourceFileLocation: Optional[SourceFileLocation] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceFileLocation())
        .map(value =>
          zio.aws.transfer.model.primitives.SourceFileLocation(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.DeleteStepDetails
  ): zio.aws.transfer.model.DeleteStepDetails.ReadOnly = new Wrapper(impl)
}
