package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{ExternalId, ServerId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeAccessRequest(
    serverId: ServerId,
    externalId: ExternalId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.DescribeAccessRequest = {
    import DescribeAccessRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.DescribeAccessRequest
      .builder()
      .serverId(ServerId.unwrap(serverId): java.lang.String)
      .externalId(ExternalId.unwrap(externalId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.DescribeAccessRequest.ReadOnly =
    zio.aws.transfer.model.DescribeAccessRequest.wrap(buildAwsValue())
}
object DescribeAccessRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.DescribeAccessRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.DescribeAccessRequest =
      zio.aws.transfer.model.DescribeAccessRequest(serverId, externalId)
    def serverId: ServerId
    def externalId: ExternalId
    def getServerId: ZIO[Any, Nothing, ServerId] = ZIO.succeed(serverId)
    def getExternalId: ZIO[Any, Nothing, ExternalId] = ZIO.succeed(externalId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.DescribeAccessRequest
  ) extends zio.aws.transfer.model.DescribeAccessRequest.ReadOnly {
    override val serverId: ServerId =
      zio.aws.transfer.model.primitives.ServerId(impl.serverId())
    override val externalId: ExternalId =
      zio.aws.transfer.model.primitives.ExternalId(impl.externalId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.DescribeAccessRequest
  ): zio.aws.transfer.model.DescribeAccessRequest.ReadOnly = new Wrapper(impl)
}
