package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.CertificateId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeCertificateRequest(certificateId: CertificateId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.DescribeCertificateRequest = {
    import DescribeCertificateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.DescribeCertificateRequest
      .builder()
      .certificateId(CertificateId.unwrap(certificateId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.DescribeCertificateRequest.ReadOnly =
    zio.aws.transfer.model.DescribeCertificateRequest.wrap(buildAwsValue())
}
object DescribeCertificateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.DescribeCertificateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.DescribeCertificateRequest =
      zio.aws.transfer.model.DescribeCertificateRequest(certificateId)
    def certificateId: CertificateId
    def getCertificateId: ZIO[Any, Nothing, CertificateId] =
      ZIO.succeed(certificateId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.DescribeCertificateRequest
  ) extends zio.aws.transfer.model.DescribeCertificateRequest.ReadOnly {
    override val certificateId: CertificateId =
      zio.aws.transfer.model.primitives.CertificateId(impl.certificateId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.DescribeCertificateRequest
  ): zio.aws.transfer.model.DescribeCertificateRequest.ReadOnly = new Wrapper(
    impl
  )
}
