package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{WorkflowId, ExecutionId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeExecutionRequest(
    executionId: ExecutionId,
    workflowId: WorkflowId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.DescribeExecutionRequest = {
    import DescribeExecutionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.DescribeExecutionRequest
      .builder()
      .executionId(ExecutionId.unwrap(executionId): java.lang.String)
      .workflowId(WorkflowId.unwrap(workflowId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.DescribeExecutionRequest.ReadOnly =
    zio.aws.transfer.model.DescribeExecutionRequest.wrap(buildAwsValue())
}
object DescribeExecutionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.DescribeExecutionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.DescribeExecutionRequest =
      zio.aws.transfer.model.DescribeExecutionRequest(executionId, workflowId)
    def executionId: ExecutionId
    def workflowId: WorkflowId
    def getExecutionId: ZIO[Any, Nothing, ExecutionId] =
      ZIO.succeed(executionId)
    def getWorkflowId: ZIO[Any, Nothing, WorkflowId] = ZIO.succeed(workflowId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.DescribeExecutionRequest
  ) extends zio.aws.transfer.model.DescribeExecutionRequest.ReadOnly {
    override val executionId: ExecutionId =
      zio.aws.transfer.model.primitives.ExecutionId(impl.executionId())
    override val workflowId: WorkflowId =
      zio.aws.transfer.model.primitives.WorkflowId(impl.workflowId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.DescribeExecutionRequest
  ): zio.aws.transfer.model.DescribeExecutionRequest.ReadOnly = new Wrapper(
    impl
  )
}
