package zio.aws.transfer.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeHostKeyResponse(
    hostKey: zio.aws.transfer.model.DescribedHostKey
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.DescribeHostKeyResponse = {
    import DescribeHostKeyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.DescribeHostKeyResponse
      .builder()
      .hostKey(hostKey.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.DescribeHostKeyResponse.ReadOnly =
    zio.aws.transfer.model.DescribeHostKeyResponse.wrap(buildAwsValue())
}
object DescribeHostKeyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.DescribeHostKeyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.DescribeHostKeyResponse =
      zio.aws.transfer.model.DescribeHostKeyResponse(hostKey.asEditable)
    def hostKey: zio.aws.transfer.model.DescribedHostKey.ReadOnly
    def getHostKey
        : ZIO[Any, Nothing, zio.aws.transfer.model.DescribedHostKey.ReadOnly] =
      ZIO.succeed(hostKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.DescribeHostKeyResponse
  ) extends zio.aws.transfer.model.DescribeHostKeyResponse.ReadOnly {
    override val hostKey: zio.aws.transfer.model.DescribedHostKey.ReadOnly =
      zio.aws.transfer.model.DescribedHostKey.wrap(impl.hostKey())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.DescribeHostKeyResponse
  ): zio.aws.transfer.model.DescribeHostKeyResponse.ReadOnly = new Wrapper(impl)
}
