package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.ProfileId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeProfileRequest(profileId: ProfileId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.DescribeProfileRequest = {
    import DescribeProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.DescribeProfileRequest
      .builder()
      .profileId(ProfileId.unwrap(profileId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.DescribeProfileRequest.ReadOnly =
    zio.aws.transfer.model.DescribeProfileRequest.wrap(buildAwsValue())
}
object DescribeProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.DescribeProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.DescribeProfileRequest =
      zio.aws.transfer.model.DescribeProfileRequest(profileId)
    def profileId: ProfileId
    def getProfileId: ZIO[Any, Nothing, ProfileId] = ZIO.succeed(profileId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.DescribeProfileRequest
  ) extends zio.aws.transfer.model.DescribeProfileRequest.ReadOnly {
    override val profileId: ProfileId =
      zio.aws.transfer.model.primitives.ProfileId(impl.profileId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.DescribeProfileRequest
  ): zio.aws.transfer.model.DescribeProfileRequest.ReadOnly = new Wrapper(impl)
}
