package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{
  ProfileId,
  ServerId,
  Arn,
  HomeDirectory,
  Description,
  AgreementId,
  Role
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribedAgreement(
    arn: Arn,
    agreementId: Optional[AgreementId] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    status: Optional[zio.aws.transfer.model.AgreementStatusType] =
      Optional.Absent,
    serverId: Optional[ServerId] = Optional.Absent,
    localProfileId: Optional[ProfileId] = Optional.Absent,
    partnerProfileId: Optional[ProfileId] = Optional.Absent,
    baseDirectory: Optional[HomeDirectory] = Optional.Absent,
    accessRole: Optional[Role] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.transfer.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.DescribedAgreement = {
    import DescribedAgreement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.DescribedAgreement
      .builder()
      .arn(Arn.unwrap(arn): java.lang.String)
      .optionallyWith(
        agreementId.map(value => AgreementId.unwrap(value): java.lang.String)
      )(_.agreementId)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        serverId.map(value => ServerId.unwrap(value): java.lang.String)
      )(_.serverId)
      .optionallyWith(
        localProfileId.map(value => ProfileId.unwrap(value): java.lang.String)
      )(_.localProfileId)
      .optionallyWith(
        partnerProfileId.map(value => ProfileId.unwrap(value): java.lang.String)
      )(_.partnerProfileId)
      .optionallyWith(
        baseDirectory.map(value =>
          HomeDirectory.unwrap(value): java.lang.String
        )
      )(_.baseDirectory)
      .optionallyWith(
        accessRole.map(value => Role.unwrap(value): java.lang.String)
      )(_.accessRole)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.DescribedAgreement.ReadOnly =
    zio.aws.transfer.model.DescribedAgreement.wrap(buildAwsValue())
}
object DescribedAgreement {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.DescribedAgreement
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.DescribedAgreement =
      zio.aws.transfer.model.DescribedAgreement(
        arn,
        agreementId.map(value => value),
        description.map(value => value),
        status.map(value => value),
        serverId.map(value => value),
        localProfileId.map(value => value),
        partnerProfileId.map(value => value),
        baseDirectory.map(value => value),
        accessRole.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def arn: Arn
    def agreementId: Optional[AgreementId]
    def description: Optional[Description]
    def status: Optional[zio.aws.transfer.model.AgreementStatusType]
    def serverId: Optional[ServerId]
    def localProfileId: Optional[ProfileId]
    def partnerProfileId: Optional[ProfileId]
    def baseDirectory: Optional[HomeDirectory]
    def accessRole: Optional[Role]
    def tags: Optional[List[zio.aws.transfer.model.Tag.ReadOnly]]
    def getArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(arn)
    def getAgreementId: ZIO[Any, AwsError, AgreementId] =
      AwsError.unwrapOptionField("agreementId", agreementId)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.transfer.model.AgreementStatusType] =
      AwsError.unwrapOptionField("status", status)
    def getServerId: ZIO[Any, AwsError, ServerId] =
      AwsError.unwrapOptionField("serverId", serverId)
    def getLocalProfileId: ZIO[Any, AwsError, ProfileId] =
      AwsError.unwrapOptionField("localProfileId", localProfileId)
    def getPartnerProfileId: ZIO[Any, AwsError, ProfileId] =
      AwsError.unwrapOptionField("partnerProfileId", partnerProfileId)
    def getBaseDirectory: ZIO[Any, AwsError, HomeDirectory] =
      AwsError.unwrapOptionField("baseDirectory", baseDirectory)
    def getAccessRole: ZIO[Any, AwsError, Role] =
      AwsError.unwrapOptionField("accessRole", accessRole)
    def getTags: ZIO[Any, AwsError, List[zio.aws.transfer.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.DescribedAgreement
  ) extends zio.aws.transfer.model.DescribedAgreement.ReadOnly {
    override val arn: Arn = zio.aws.transfer.model.primitives.Arn(impl.arn())
    override val agreementId: Optional[AgreementId] = zio.aws.core.internal
      .optionalFromNullable(impl.agreementId())
      .map(value => zio.aws.transfer.model.primitives.AgreementId(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.transfer.model.primitives.Description(value))
    override val status: Optional[zio.aws.transfer.model.AgreementStatusType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.transfer.model.AgreementStatusType.wrap(value))
    override val serverId: Optional[ServerId] = zio.aws.core.internal
      .optionalFromNullable(impl.serverId())
      .map(value => zio.aws.transfer.model.primitives.ServerId(value))
    override val localProfileId: Optional[ProfileId] = zio.aws.core.internal
      .optionalFromNullable(impl.localProfileId())
      .map(value => zio.aws.transfer.model.primitives.ProfileId(value))
    override val partnerProfileId: Optional[ProfileId] = zio.aws.core.internal
      .optionalFromNullable(impl.partnerProfileId())
      .map(value => zio.aws.transfer.model.primitives.ProfileId(value))
    override val baseDirectory: Optional[HomeDirectory] = zio.aws.core.internal
      .optionalFromNullable(impl.baseDirectory())
      .map(value => zio.aws.transfer.model.primitives.HomeDirectory(value))
    override val accessRole: Optional[Role] = zio.aws.core.internal
      .optionalFromNullable(impl.accessRole())
      .map(value => zio.aws.transfer.model.primitives.Role(value))
    override val tags: Optional[List[zio.aws.transfer.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.transfer.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.DescribedAgreement
  ): zio.aws.transfer.model.DescribedAgreement.ReadOnly = new Wrapper(impl)
}
