package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{CertificateId, As2Id, ProfileId, Arn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribedProfile(
    arn: Arn,
    profileId: Optional[ProfileId] = Optional.Absent,
    profileType: Optional[zio.aws.transfer.model.ProfileType] = Optional.Absent,
    as2Id: Optional[As2Id] = Optional.Absent,
    certificateIds: Optional[Iterable[CertificateId]] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.transfer.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.DescribedProfile = {
    import DescribedProfile.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.DescribedProfile
      .builder()
      .arn(Arn.unwrap(arn): java.lang.String)
      .optionallyWith(
        profileId.map(value => ProfileId.unwrap(value): java.lang.String)
      )(_.profileId)
      .optionallyWith(profileType.map(value => value.unwrap))(_.profileType)
      .optionallyWith(
        as2Id.map(value => As2Id.unwrap(value): java.lang.String)
      )(_.as2Id)
      .optionallyWith(
        certificateIds.map(value =>
          value.map { item =>
            CertificateId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.certificateIds)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.DescribedProfile.ReadOnly =
    zio.aws.transfer.model.DescribedProfile.wrap(buildAwsValue())
}
object DescribedProfile {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.DescribedProfile
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.DescribedProfile =
      zio.aws.transfer.model.DescribedProfile(
        arn,
        profileId.map(value => value),
        profileType.map(value => value),
        as2Id.map(value => value),
        certificateIds.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def arn: Arn
    def profileId: Optional[ProfileId]
    def profileType: Optional[zio.aws.transfer.model.ProfileType]
    def as2Id: Optional[As2Id]
    def certificateIds: Optional[List[CertificateId]]
    def tags: Optional[List[zio.aws.transfer.model.Tag.ReadOnly]]
    def getArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(arn)
    def getProfileId: ZIO[Any, AwsError, ProfileId] =
      AwsError.unwrapOptionField("profileId", profileId)
    def getProfileType: ZIO[Any, AwsError, zio.aws.transfer.model.ProfileType] =
      AwsError.unwrapOptionField("profileType", profileType)
    def getAs2Id: ZIO[Any, AwsError, As2Id] =
      AwsError.unwrapOptionField("as2Id", as2Id)
    def getCertificateIds: ZIO[Any, AwsError, List[CertificateId]] =
      AwsError.unwrapOptionField("certificateIds", certificateIds)
    def getTags: ZIO[Any, AwsError, List[zio.aws.transfer.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.DescribedProfile
  ) extends zio.aws.transfer.model.DescribedProfile.ReadOnly {
    override val arn: Arn = zio.aws.transfer.model.primitives.Arn(impl.arn())
    override val profileId: Optional[ProfileId] = zio.aws.core.internal
      .optionalFromNullable(impl.profileId())
      .map(value => zio.aws.transfer.model.primitives.ProfileId(value))
    override val profileType: Optional[zio.aws.transfer.model.ProfileType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.profileType())
        .map(value => zio.aws.transfer.model.ProfileType.wrap(value))
    override val as2Id: Optional[As2Id] = zio.aws.core.internal
      .optionalFromNullable(impl.as2Id())
      .map(value => zio.aws.transfer.model.primitives.As2Id(value))
    override val certificateIds: Optional[List[CertificateId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificateIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.transfer.model.primitives.CertificateId(item)
          }.toList
        )
    override val tags: Optional[List[zio.aws.transfer.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.transfer.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.DescribedProfile
  ): zio.aws.transfer.model.DescribedProfile.ReadOnly = new Wrapper(impl)
}
