package zio.aws.transfer.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.transfer.model.primitives.{
  Certificate,
  PostAuthenticationLoginBanner,
  ServerId,
  ServiceManagedEgressIpAddress,
  Arn,
  PreAuthenticationLoginBanner,
  NullableRole,
  SecurityPolicyName,
  UserCount,
  HostKeyFingerprint
}
import scala.jdk.CollectionConverters._
final case class DescribedServer(
    arn: Arn,
    certificate: Optional[Certificate] = Optional.Absent,
    protocolDetails: Optional[zio.aws.transfer.model.ProtocolDetails] =
      Optional.Absent,
    domain: Optional[zio.aws.transfer.model.Domain] = Optional.Absent,
    endpointDetails: Optional[zio.aws.transfer.model.EndpointDetails] =
      Optional.Absent,
    endpointType: Optional[zio.aws.transfer.model.EndpointType] =
      Optional.Absent,
    hostKeyFingerprint: Optional[HostKeyFingerprint] = Optional.Absent,
    identityProviderDetails: Optional[
      zio.aws.transfer.model.IdentityProviderDetails
    ] = Optional.Absent,
    identityProviderType: Optional[
      zio.aws.transfer.model.IdentityProviderType
    ] = Optional.Absent,
    loggingRole: Optional[NullableRole] = Optional.Absent,
    postAuthenticationLoginBanner: Optional[PostAuthenticationLoginBanner] =
      Optional.Absent,
    preAuthenticationLoginBanner: Optional[PreAuthenticationLoginBanner] =
      Optional.Absent,
    protocols: Optional[Iterable[zio.aws.transfer.model.Protocol]] =
      Optional.Absent,
    securityPolicyName: Optional[SecurityPolicyName] = Optional.Absent,
    serverId: Optional[ServerId] = Optional.Absent,
    state: Optional[zio.aws.transfer.model.State] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.transfer.model.Tag]] = Optional.Absent,
    userCount: Optional[UserCount] = Optional.Absent,
    workflowDetails: Optional[zio.aws.transfer.model.WorkflowDetails] =
      Optional.Absent,
    structuredLogDestinations: Optional[Iterable[Arn]] = Optional.Absent,
    s3StorageOptions: Optional[zio.aws.transfer.model.S3StorageOptions] =
      Optional.Absent,
    as2ServiceManagedEgressIpAddresses: Optional[
      Iterable[ServiceManagedEgressIpAddress]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.DescribedServer = {
    import DescribedServer.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.DescribedServer
      .builder()
      .arn(Arn.unwrap(arn): java.lang.String)
      .optionallyWith(
        certificate.map(value => Certificate.unwrap(value): java.lang.String)
      )(_.certificate)
      .optionallyWith(protocolDetails.map(value => value.buildAwsValue()))(
        _.protocolDetails
      )
      .optionallyWith(domain.map(value => value.unwrap))(_.domain)
      .optionallyWith(endpointDetails.map(value => value.buildAwsValue()))(
        _.endpointDetails
      )
      .optionallyWith(endpointType.map(value => value.unwrap))(_.endpointType)
      .optionallyWith(
        hostKeyFingerprint.map(value =>
          HostKeyFingerprint.unwrap(value): java.lang.String
        )
      )(_.hostKeyFingerprint)
      .optionallyWith(
        identityProviderDetails.map(value => value.buildAwsValue())
      )(_.identityProviderDetails)
      .optionallyWith(identityProviderType.map(value => value.unwrap))(
        _.identityProviderType
      )
      .optionallyWith(
        loggingRole.map(value => NullableRole.unwrap(value): java.lang.String)
      )(_.loggingRole)
      .optionallyWith(
        postAuthenticationLoginBanner.map(value =>
          PostAuthenticationLoginBanner.unwrap(value): java.lang.String
        )
      )(_.postAuthenticationLoginBanner)
      .optionallyWith(
        preAuthenticationLoginBanner.map(value =>
          PreAuthenticationLoginBanner.unwrap(value): java.lang.String
        )
      )(_.preAuthenticationLoginBanner)
      .optionallyWith(
        protocols.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.protocolsWithStrings)
      .optionallyWith(
        securityPolicyName.map(value =>
          SecurityPolicyName.unwrap(value): java.lang.String
        )
      )(_.securityPolicyName)
      .optionallyWith(
        serverId.map(value => ServerId.unwrap(value): java.lang.String)
      )(_.serverId)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(userCount.map(value => UserCount.unwrap(value): Integer))(
        _.userCount
      )
      .optionallyWith(workflowDetails.map(value => value.buildAwsValue()))(
        _.workflowDetails
      )
      .optionallyWith(
        structuredLogDestinations.map(value =>
          value.map { item =>
            Arn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.structuredLogDestinations)
      .optionallyWith(s3StorageOptions.map(value => value.buildAwsValue()))(
        _.s3StorageOptions
      )
      .optionallyWith(
        as2ServiceManagedEgressIpAddresses.map(value =>
          value.map { item =>
            ServiceManagedEgressIpAddress.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.as2ServiceManagedEgressIpAddresses)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.DescribedServer.ReadOnly =
    zio.aws.transfer.model.DescribedServer.wrap(buildAwsValue())
}
object DescribedServer {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.DescribedServer
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.DescribedServer =
      zio.aws.transfer.model.DescribedServer(
        arn,
        certificate.map(value => value),
        protocolDetails.map(value => value.asEditable),
        domain.map(value => value),
        endpointDetails.map(value => value.asEditable),
        endpointType.map(value => value),
        hostKeyFingerprint.map(value => value),
        identityProviderDetails.map(value => value.asEditable),
        identityProviderType.map(value => value),
        loggingRole.map(value => value),
        postAuthenticationLoginBanner.map(value => value),
        preAuthenticationLoginBanner.map(value => value),
        protocols.map(value => value),
        securityPolicyName.map(value => value),
        serverId.map(value => value),
        state.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        userCount.map(value => value),
        workflowDetails.map(value => value.asEditable),
        structuredLogDestinations.map(value => value),
        s3StorageOptions.map(value => value.asEditable),
        as2ServiceManagedEgressIpAddresses.map(value => value)
      )
    def arn: Arn
    def certificate: Optional[Certificate]
    def protocolDetails
        : Optional[zio.aws.transfer.model.ProtocolDetails.ReadOnly]
    def domain: Optional[zio.aws.transfer.model.Domain]
    def endpointDetails
        : Optional[zio.aws.transfer.model.EndpointDetails.ReadOnly]
    def endpointType: Optional[zio.aws.transfer.model.EndpointType]
    def hostKeyFingerprint: Optional[HostKeyFingerprint]
    def identityProviderDetails
        : Optional[zio.aws.transfer.model.IdentityProviderDetails.ReadOnly]
    def identityProviderType
        : Optional[zio.aws.transfer.model.IdentityProviderType]
    def loggingRole: Optional[NullableRole]
    def postAuthenticationLoginBanner: Optional[PostAuthenticationLoginBanner]
    def preAuthenticationLoginBanner: Optional[PreAuthenticationLoginBanner]
    def protocols: Optional[List[zio.aws.transfer.model.Protocol]]
    def securityPolicyName: Optional[SecurityPolicyName]
    def serverId: Optional[ServerId]
    def state: Optional[zio.aws.transfer.model.State]
    def tags: Optional[List[zio.aws.transfer.model.Tag.ReadOnly]]
    def userCount: Optional[UserCount]
    def workflowDetails
        : Optional[zio.aws.transfer.model.WorkflowDetails.ReadOnly]
    def structuredLogDestinations: Optional[List[Arn]]
    def s3StorageOptions
        : Optional[zio.aws.transfer.model.S3StorageOptions.ReadOnly]
    def as2ServiceManagedEgressIpAddresses
        : Optional[List[ServiceManagedEgressIpAddress]]
    def getArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(arn)
    def getCertificate: ZIO[Any, AwsError, Certificate] =
      AwsError.unwrapOptionField("certificate", certificate)
    def getProtocolDetails
        : ZIO[Any, AwsError, zio.aws.transfer.model.ProtocolDetails.ReadOnly] =
      AwsError.unwrapOptionField("protocolDetails", protocolDetails)
    def getDomain: ZIO[Any, AwsError, zio.aws.transfer.model.Domain] =
      AwsError.unwrapOptionField("domain", domain)
    def getEndpointDetails
        : ZIO[Any, AwsError, zio.aws.transfer.model.EndpointDetails.ReadOnly] =
      AwsError.unwrapOptionField("endpointDetails", endpointDetails)
    def getEndpointType
        : ZIO[Any, AwsError, zio.aws.transfer.model.EndpointType] =
      AwsError.unwrapOptionField("endpointType", endpointType)
    def getHostKeyFingerprint: ZIO[Any, AwsError, HostKeyFingerprint] =
      AwsError.unwrapOptionField("hostKeyFingerprint", hostKeyFingerprint)
    def getIdentityProviderDetails: ZIO[
      Any,
      AwsError,
      zio.aws.transfer.model.IdentityProviderDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "identityProviderDetails",
      identityProviderDetails
    )
    def getIdentityProviderType
        : ZIO[Any, AwsError, zio.aws.transfer.model.IdentityProviderType] =
      AwsError.unwrapOptionField("identityProviderType", identityProviderType)
    def getLoggingRole: ZIO[Any, AwsError, NullableRole] =
      AwsError.unwrapOptionField("loggingRole", loggingRole)
    def getPostAuthenticationLoginBanner
        : ZIO[Any, AwsError, PostAuthenticationLoginBanner] =
      AwsError.unwrapOptionField(
        "postAuthenticationLoginBanner",
        postAuthenticationLoginBanner
      )
    def getPreAuthenticationLoginBanner
        : ZIO[Any, AwsError, PreAuthenticationLoginBanner] =
      AwsError.unwrapOptionField(
        "preAuthenticationLoginBanner",
        preAuthenticationLoginBanner
      )
    def getProtocols
        : ZIO[Any, AwsError, List[zio.aws.transfer.model.Protocol]] =
      AwsError.unwrapOptionField("protocols", protocols)
    def getSecurityPolicyName: ZIO[Any, AwsError, SecurityPolicyName] =
      AwsError.unwrapOptionField("securityPolicyName", securityPolicyName)
    def getServerId: ZIO[Any, AwsError, ServerId] =
      AwsError.unwrapOptionField("serverId", serverId)
    def getState: ZIO[Any, AwsError, zio.aws.transfer.model.State] =
      AwsError.unwrapOptionField("state", state)
    def getTags: ZIO[Any, AwsError, List[zio.aws.transfer.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getUserCount: ZIO[Any, AwsError, UserCount] =
      AwsError.unwrapOptionField("userCount", userCount)
    def getWorkflowDetails
        : ZIO[Any, AwsError, zio.aws.transfer.model.WorkflowDetails.ReadOnly] =
      AwsError.unwrapOptionField("workflowDetails", workflowDetails)
    def getStructuredLogDestinations: ZIO[Any, AwsError, List[Arn]] = AwsError
      .unwrapOptionField("structuredLogDestinations", structuredLogDestinations)
    def getS3StorageOptions
        : ZIO[Any, AwsError, zio.aws.transfer.model.S3StorageOptions.ReadOnly] =
      AwsError.unwrapOptionField("s3StorageOptions", s3StorageOptions)
    def getAs2ServiceManagedEgressIpAddresses
        : ZIO[Any, AwsError, List[ServiceManagedEgressIpAddress]] =
      AwsError.unwrapOptionField(
        "as2ServiceManagedEgressIpAddresses",
        as2ServiceManagedEgressIpAddresses
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.DescribedServer
  ) extends zio.aws.transfer.model.DescribedServer.ReadOnly {
    override val arn: Arn = zio.aws.transfer.model.primitives.Arn(impl.arn())
    override val certificate: Optional[Certificate] = zio.aws.core.internal
      .optionalFromNullable(impl.certificate())
      .map(value => zio.aws.transfer.model.primitives.Certificate(value))
    override val protocolDetails
        : Optional[zio.aws.transfer.model.ProtocolDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.protocolDetails())
        .map(value => zio.aws.transfer.model.ProtocolDetails.wrap(value))
    override val domain: Optional[zio.aws.transfer.model.Domain] =
      zio.aws.core.internal
        .optionalFromNullable(impl.domain())
        .map(value => zio.aws.transfer.model.Domain.wrap(value))
    override val endpointDetails
        : Optional[zio.aws.transfer.model.EndpointDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endpointDetails())
        .map(value => zio.aws.transfer.model.EndpointDetails.wrap(value))
    override val endpointType: Optional[zio.aws.transfer.model.EndpointType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endpointType())
        .map(value => zio.aws.transfer.model.EndpointType.wrap(value))
    override val hostKeyFingerprint: Optional[HostKeyFingerprint] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hostKeyFingerprint())
        .map(value =>
          zio.aws.transfer.model.primitives.HostKeyFingerprint(value)
        )
    override val identityProviderDetails
        : Optional[zio.aws.transfer.model.IdentityProviderDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.identityProviderDetails())
        .map(value =>
          zio.aws.transfer.model.IdentityProviderDetails.wrap(value)
        )
    override val identityProviderType
        : Optional[zio.aws.transfer.model.IdentityProviderType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.identityProviderType())
        .map(value => zio.aws.transfer.model.IdentityProviderType.wrap(value))
    override val loggingRole: Optional[NullableRole] = zio.aws.core.internal
      .optionalFromNullable(impl.loggingRole())
      .map(value => zio.aws.transfer.model.primitives.NullableRole(value))
    override val postAuthenticationLoginBanner
        : Optional[PostAuthenticationLoginBanner] = zio.aws.core.internal
      .optionalFromNullable(impl.postAuthenticationLoginBanner())
      .map(value =>
        zio.aws.transfer.model.primitives.PostAuthenticationLoginBanner(value)
      )
    override val preAuthenticationLoginBanner
        : Optional[PreAuthenticationLoginBanner] = zio.aws.core.internal
      .optionalFromNullable(impl.preAuthenticationLoginBanner())
      .map(value =>
        zio.aws.transfer.model.primitives.PreAuthenticationLoginBanner(value)
      )
    override val protocols: Optional[List[zio.aws.transfer.model.Protocol]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.protocols())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.transfer.model.Protocol.wrap(item)
          }.toList
        )
    override val securityPolicyName: Optional[SecurityPolicyName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityPolicyName())
        .map(value =>
          zio.aws.transfer.model.primitives.SecurityPolicyName(value)
        )
    override val serverId: Optional[ServerId] = zio.aws.core.internal
      .optionalFromNullable(impl.serverId())
      .map(value => zio.aws.transfer.model.primitives.ServerId(value))
    override val state: Optional[zio.aws.transfer.model.State] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.transfer.model.State.wrap(value))
    override val tags: Optional[List[zio.aws.transfer.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.transfer.model.Tag.wrap(item)
          }.toList
        )
    override val userCount: Optional[UserCount] = zio.aws.core.internal
      .optionalFromNullable(impl.userCount())
      .map(value => zio.aws.transfer.model.primitives.UserCount(value))
    override val workflowDetails
        : Optional[zio.aws.transfer.model.WorkflowDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.workflowDetails())
        .map(value => zio.aws.transfer.model.WorkflowDetails.wrap(value))
    override val structuredLogDestinations: Optional[List[Arn]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.structuredLogDestinations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.transfer.model.primitives.Arn(item)
          }.toList
        )
    override val s3StorageOptions
        : Optional[zio.aws.transfer.model.S3StorageOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3StorageOptions())
        .map(value => zio.aws.transfer.model.S3StorageOptions.wrap(value))
    override val as2ServiceManagedEgressIpAddresses
        : Optional[List[ServiceManagedEgressIpAddress]] = zio.aws.core.internal
      .optionalFromNullable(impl.as2ServiceManagedEgressIpAddresses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.transfer.model.primitives.ServiceManagedEgressIpAddress(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.DescribedServer
  ): zio.aws.transfer.model.DescribedServer.ReadOnly = new Wrapper(impl)
}
