package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{MapTarget, MapEntry}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class HomeDirectoryMapEntry(
    entry: MapEntry,
    target: MapTarget,
    `type`: Optional[zio.aws.transfer.model.MapType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.HomeDirectoryMapEntry = {
    import HomeDirectoryMapEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.HomeDirectoryMapEntry
      .builder()
      .entry(MapEntry.unwrap(entry): java.lang.String)
      .target(MapTarget.unwrap(target): java.lang.String)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.HomeDirectoryMapEntry.ReadOnly =
    zio.aws.transfer.model.HomeDirectoryMapEntry.wrap(buildAwsValue())
}
object HomeDirectoryMapEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.HomeDirectoryMapEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.HomeDirectoryMapEntry =
      zio.aws.transfer.model
        .HomeDirectoryMapEntry(entry, target, `type`.map(value => value))
    def entry: MapEntry
    def target: MapTarget
    def `type`: Optional[zio.aws.transfer.model.MapType]
    def getEntry: ZIO[Any, Nothing, MapEntry] = ZIO.succeed(entry)
    def getTarget: ZIO[Any, Nothing, MapTarget] = ZIO.succeed(target)
    def getType: ZIO[Any, AwsError, zio.aws.transfer.model.MapType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.HomeDirectoryMapEntry
  ) extends zio.aws.transfer.model.HomeDirectoryMapEntry.ReadOnly {
    override val entry: MapEntry =
      zio.aws.transfer.model.primitives.MapEntry(impl.entry())
    override val target: MapTarget =
      zio.aws.transfer.model.primitives.MapTarget(impl.target())
    override val `type`: Optional[zio.aws.transfer.model.MapType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.transfer.model.MapType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.HomeDirectoryMapEntry
  ): zio.aws.transfer.model.HomeDirectoryMapEntry.ReadOnly = new Wrapper(impl)
}
