package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{HostKeyDescription, HostKey, ServerId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ImportHostKeyRequest(
    serverId: ServerId,
    hostKeyBody: HostKey,
    description: Optional[HostKeyDescription] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.transfer.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.ImportHostKeyRequest = {
    import ImportHostKeyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.ImportHostKeyRequest
      .builder()
      .serverId(ServerId.unwrap(serverId): java.lang.String)
      .hostKeyBody(HostKey.unwrap(hostKeyBody): java.lang.String)
      .optionallyWith(
        description.map(value =>
          HostKeyDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.ImportHostKeyRequest.ReadOnly =
    zio.aws.transfer.model.ImportHostKeyRequest.wrap(buildAwsValue())
}
object ImportHostKeyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.ImportHostKeyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.ImportHostKeyRequest =
      zio.aws.transfer.model.ImportHostKeyRequest(
        serverId,
        hostKeyBody,
        description.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def serverId: ServerId
    def hostKeyBody: HostKey
    def description: Optional[HostKeyDescription]
    def tags: Optional[List[zio.aws.transfer.model.Tag.ReadOnly]]
    def getServerId: ZIO[Any, Nothing, ServerId] = ZIO.succeed(serverId)
    def getHostKeyBody: ZIO[Any, Nothing, HostKey] = ZIO.succeed(hostKeyBody)
    def getDescription: ZIO[Any, AwsError, HostKeyDescription] =
      AwsError.unwrapOptionField("description", description)
    def getTags: ZIO[Any, AwsError, List[zio.aws.transfer.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.ImportHostKeyRequest
  ) extends zio.aws.transfer.model.ImportHostKeyRequest.ReadOnly {
    override val serverId: ServerId =
      zio.aws.transfer.model.primitives.ServerId(impl.serverId())
    override val hostKeyBody: HostKey =
      zio.aws.transfer.model.primitives.HostKey(impl.hostKeyBody())
    override val description: Optional[HostKeyDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.transfer.model.primitives.HostKeyDescription(value)
        )
    override val tags: Optional[List[zio.aws.transfer.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.transfer.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.ImportHostKeyRequest
  ): zio.aws.transfer.model.ImportHostKeyRequest.ReadOnly = new Wrapper(impl)
}
