package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListCertificatesResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    certificates: Iterable[zio.aws.transfer.model.ListedCertificate]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.ListCertificatesResponse = {
    import ListCertificatesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.ListCertificatesResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .certificates(certificates.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.ListCertificatesResponse.ReadOnly =
    zio.aws.transfer.model.ListCertificatesResponse.wrap(buildAwsValue())
}
object ListCertificatesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.ListCertificatesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.ListCertificatesResponse =
      zio.aws.transfer.model.ListCertificatesResponse(
        nextToken.map(value => value),
        certificates.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[NextToken]
    def certificates: List[zio.aws.transfer.model.ListedCertificate.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getCertificates: ZIO[Any, Nothing, List[
      zio.aws.transfer.model.ListedCertificate.ReadOnly
    ]] = ZIO.succeed(certificates)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.ListCertificatesResponse
  ) extends zio.aws.transfer.model.ListCertificatesResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.transfer.model.primitives.NextToken(value))
    override val certificates
        : List[zio.aws.transfer.model.ListedCertificate.ReadOnly] = impl
      .certificates()
      .asScala
      .map { item =>
        zio.aws.transfer.model.ListedCertificate.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.ListCertificatesResponse
  ): zio.aws.transfer.model.ListCertificatesResponse.ReadOnly = new Wrapper(
    impl
  )
}
