package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListConnectorsResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    connectors: Iterable[zio.aws.transfer.model.ListedConnector]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.ListConnectorsResponse = {
    import ListConnectorsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.ListConnectorsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .connectors(connectors.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.ListConnectorsResponse.ReadOnly =
    zio.aws.transfer.model.ListConnectorsResponse.wrap(buildAwsValue())
}
object ListConnectorsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.ListConnectorsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.ListConnectorsResponse =
      zio.aws.transfer.model.ListConnectorsResponse(
        nextToken.map(value => value),
        connectors.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[NextToken]
    def connectors: List[zio.aws.transfer.model.ListedConnector.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getConnectors: ZIO[Any, Nothing, List[
      zio.aws.transfer.model.ListedConnector.ReadOnly
    ]] = ZIO.succeed(connectors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.ListConnectorsResponse
  ) extends zio.aws.transfer.model.ListConnectorsResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.transfer.model.primitives.NextToken(value))
    override val connectors
        : List[zio.aws.transfer.model.ListedConnector.ReadOnly] = impl
      .connectors()
      .asScala
      .map { item =>
        zio.aws.transfer.model.ListedConnector.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.ListConnectorsResponse
  ): zio.aws.transfer.model.ListConnectorsResponse.ReadOnly = new Wrapper(impl)
}
