package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{WorkflowId, NextToken}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListExecutionsResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    workflowId: WorkflowId,
    executions: Iterable[zio.aws.transfer.model.ListedExecution]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.ListExecutionsResponse = {
    import ListExecutionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.ListExecutionsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .workflowId(WorkflowId.unwrap(workflowId): java.lang.String)
      .executions(executions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.ListExecutionsResponse.ReadOnly =
    zio.aws.transfer.model.ListExecutionsResponse.wrap(buildAwsValue())
}
object ListExecutionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.ListExecutionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.ListExecutionsResponse =
      zio.aws.transfer.model.ListExecutionsResponse(
        nextToken.map(value => value),
        workflowId,
        executions.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[NextToken]
    def workflowId: WorkflowId
    def executions: List[zio.aws.transfer.model.ListedExecution.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getWorkflowId: ZIO[Any, Nothing, WorkflowId] = ZIO.succeed(workflowId)
    def getExecutions: ZIO[Any, Nothing, List[
      zio.aws.transfer.model.ListedExecution.ReadOnly
    ]] = ZIO.succeed(executions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.ListExecutionsResponse
  ) extends zio.aws.transfer.model.ListExecutionsResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.transfer.model.primitives.NextToken(value))
    override val workflowId: WorkflowId =
      zio.aws.transfer.model.primitives.WorkflowId(impl.workflowId())
    override val executions
        : List[zio.aws.transfer.model.ListedExecution.ReadOnly] = impl
      .executions()
      .asScala
      .map { item =>
        zio.aws.transfer.model.ListedExecution.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.ListExecutionsResponse
  ): zio.aws.transfer.model.ListExecutionsResponse.ReadOnly = new Wrapper(impl)
}
