package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{NextToken, Arn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceResponse(
    arn: Optional[Arn] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.transfer.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.ListTagsForResourceResponse = {
    import ListTagsForResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.ListTagsForResourceResponse
      .builder()
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.ListTagsForResourceResponse.ReadOnly =
    zio.aws.transfer.model.ListTagsForResourceResponse.wrap(buildAwsValue())
}
object ListTagsForResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.ListTagsForResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.ListTagsForResourceResponse =
      zio.aws.transfer.model.ListTagsForResourceResponse(
        arn.map(value => value),
        nextToken.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def arn: Optional[Arn]
    def nextToken: Optional[NextToken]
    def tags: Optional[List[zio.aws.transfer.model.Tag.ReadOnly]]
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getTags: ZIO[Any, AwsError, List[zio.aws.transfer.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.ListTagsForResourceResponse
  ) extends zio.aws.transfer.model.ListTagsForResourceResponse.ReadOnly {
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.transfer.model.primitives.Arn(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.transfer.model.primitives.NextToken(value))
    override val tags: Optional[List[zio.aws.transfer.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.transfer.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.ListTagsForResourceResponse
  ): zio.aws.transfer.model.ListTagsForResourceResponse.ReadOnly = new Wrapper(
    impl
  )
}
