package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{
  ProfileId,
  ServerId,
  Arn,
  Description,
  AgreementId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListedAgreement(
    arn: Optional[Arn] = Optional.Absent,
    agreementId: Optional[AgreementId] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    status: Optional[zio.aws.transfer.model.AgreementStatusType] =
      Optional.Absent,
    serverId: Optional[ServerId] = Optional.Absent,
    localProfileId: Optional[ProfileId] = Optional.Absent,
    partnerProfileId: Optional[ProfileId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.ListedAgreement = {
    import ListedAgreement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.ListedAgreement
      .builder()
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        agreementId.map(value => AgreementId.unwrap(value): java.lang.String)
      )(_.agreementId)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        serverId.map(value => ServerId.unwrap(value): java.lang.String)
      )(_.serverId)
      .optionallyWith(
        localProfileId.map(value => ProfileId.unwrap(value): java.lang.String)
      )(_.localProfileId)
      .optionallyWith(
        partnerProfileId.map(value => ProfileId.unwrap(value): java.lang.String)
      )(_.partnerProfileId)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.ListedAgreement.ReadOnly =
    zio.aws.transfer.model.ListedAgreement.wrap(buildAwsValue())
}
object ListedAgreement {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.ListedAgreement
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.ListedAgreement =
      zio.aws.transfer.model.ListedAgreement(
        arn.map(value => value),
        agreementId.map(value => value),
        description.map(value => value),
        status.map(value => value),
        serverId.map(value => value),
        localProfileId.map(value => value),
        partnerProfileId.map(value => value)
      )
    def arn: Optional[Arn]
    def agreementId: Optional[AgreementId]
    def description: Optional[Description]
    def status: Optional[zio.aws.transfer.model.AgreementStatusType]
    def serverId: Optional[ServerId]
    def localProfileId: Optional[ProfileId]
    def partnerProfileId: Optional[ProfileId]
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getAgreementId: ZIO[Any, AwsError, AgreementId] =
      AwsError.unwrapOptionField("agreementId", agreementId)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.transfer.model.AgreementStatusType] =
      AwsError.unwrapOptionField("status", status)
    def getServerId: ZIO[Any, AwsError, ServerId] =
      AwsError.unwrapOptionField("serverId", serverId)
    def getLocalProfileId: ZIO[Any, AwsError, ProfileId] =
      AwsError.unwrapOptionField("localProfileId", localProfileId)
    def getPartnerProfileId: ZIO[Any, AwsError, ProfileId] =
      AwsError.unwrapOptionField("partnerProfileId", partnerProfileId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.ListedAgreement
  ) extends zio.aws.transfer.model.ListedAgreement.ReadOnly {
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.transfer.model.primitives.Arn(value))
    override val agreementId: Optional[AgreementId] = zio.aws.core.internal
      .optionalFromNullable(impl.agreementId())
      .map(value => zio.aws.transfer.model.primitives.AgreementId(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.transfer.model.primitives.Description(value))
    override val status: Optional[zio.aws.transfer.model.AgreementStatusType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.transfer.model.AgreementStatusType.wrap(value))
    override val serverId: Optional[ServerId] = zio.aws.core.internal
      .optionalFromNullable(impl.serverId())
      .map(value => zio.aws.transfer.model.primitives.ServerId(value))
    override val localProfileId: Optional[ProfileId] = zio.aws.core.internal
      .optionalFromNullable(impl.localProfileId())
      .map(value => zio.aws.transfer.model.primitives.ProfileId(value))
    override val partnerProfileId: Optional[ProfileId] = zio.aws.core.internal
      .optionalFromNullable(impl.partnerProfileId())
      .map(value => zio.aws.transfer.model.primitives.ProfileId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.ListedAgreement
  ): zio.aws.transfer.model.ListedAgreement.ReadOnly = new Wrapper(impl)
}
