package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{Url, ConnectorId, Arn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListedConnector(
    arn: Optional[Arn] = Optional.Absent,
    connectorId: Optional[ConnectorId] = Optional.Absent,
    url: Optional[Url] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.ListedConnector = {
    import ListedConnector.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.ListedConnector
      .builder()
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        connectorId.map(value => ConnectorId.unwrap(value): java.lang.String)
      )(_.connectorId)
      .optionallyWith(url.map(value => Url.unwrap(value): java.lang.String))(
        _.url
      )
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.ListedConnector.ReadOnly =
    zio.aws.transfer.model.ListedConnector.wrap(buildAwsValue())
}
object ListedConnector {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.ListedConnector
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.ListedConnector =
      zio.aws.transfer.model.ListedConnector(
        arn.map(value => value),
        connectorId.map(value => value),
        url.map(value => value)
      )
    def arn: Optional[Arn]
    def connectorId: Optional[ConnectorId]
    def url: Optional[Url]
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getConnectorId: ZIO[Any, AwsError, ConnectorId] =
      AwsError.unwrapOptionField("connectorId", connectorId)
    def getUrl: ZIO[Any, AwsError, Url] = AwsError.unwrapOptionField("url", url)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.ListedConnector
  ) extends zio.aws.transfer.model.ListedConnector.ReadOnly {
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.transfer.model.primitives.Arn(value))
    override val connectorId: Optional[ConnectorId] = zio.aws.core.internal
      .optionalFromNullable(impl.connectorId())
      .map(value => zio.aws.transfer.model.primitives.ConnectorId(value))
    override val url: Optional[Url] = zio.aws.core.internal
      .optionalFromNullable(impl.url())
      .map(value => zio.aws.transfer.model.primitives.Url(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.ListedConnector
  ): zio.aws.transfer.model.ListedConnector.ReadOnly = new Wrapper(impl)
}
