package zio.aws.transfer.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.transfer.model.primitives.{
  Arn,
  DateImported,
  HostKeyId,
  HostKeyType,
  HostKeyFingerprint,
  HostKeyDescription
}
import scala.jdk.CollectionConverters._
final case class ListedHostKey(
    arn: Arn,
    hostKeyId: Optional[HostKeyId] = Optional.Absent,
    fingerprint: Optional[HostKeyFingerprint] = Optional.Absent,
    description: Optional[HostKeyDescription] = Optional.Absent,
    `type`: Optional[HostKeyType] = Optional.Absent,
    dateImported: Optional[DateImported] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.ListedHostKey = {
    import ListedHostKey.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.ListedHostKey
      .builder()
      .arn(Arn.unwrap(arn): java.lang.String)
      .optionallyWith(
        hostKeyId.map(value => HostKeyId.unwrap(value): java.lang.String)
      )(_.hostKeyId)
      .optionallyWith(
        fingerprint.map(value =>
          HostKeyFingerprint.unwrap(value): java.lang.String
        )
      )(_.fingerprint)
      .optionallyWith(
        description.map(value =>
          HostKeyDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        `type`.map(value => HostKeyType.unwrap(value): java.lang.String)
      )(_.`type`)
      .optionallyWith(
        dateImported.map(value => DateImported.unwrap(value): Instant)
      )(_.dateImported)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.ListedHostKey.ReadOnly =
    zio.aws.transfer.model.ListedHostKey.wrap(buildAwsValue())
}
object ListedHostKey {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.ListedHostKey
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.ListedHostKey =
      zio.aws.transfer.model.ListedHostKey(
        arn,
        hostKeyId.map(value => value),
        fingerprint.map(value => value),
        description.map(value => value),
        `type`.map(value => value),
        dateImported.map(value => value)
      )
    def arn: Arn
    def hostKeyId: Optional[HostKeyId]
    def fingerprint: Optional[HostKeyFingerprint]
    def description: Optional[HostKeyDescription]
    def `type`: Optional[HostKeyType]
    def dateImported: Optional[DateImported]
    def getArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(arn)
    def getHostKeyId: ZIO[Any, AwsError, HostKeyId] =
      AwsError.unwrapOptionField("hostKeyId", hostKeyId)
    def getFingerprint: ZIO[Any, AwsError, HostKeyFingerprint] =
      AwsError.unwrapOptionField("fingerprint", fingerprint)
    def getDescription: ZIO[Any, AwsError, HostKeyDescription] =
      AwsError.unwrapOptionField("description", description)
    def getType: ZIO[Any, AwsError, HostKeyType] =
      AwsError.unwrapOptionField("type", `type`)
    def getDateImported: ZIO[Any, AwsError, DateImported] =
      AwsError.unwrapOptionField("dateImported", dateImported)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.ListedHostKey
  ) extends zio.aws.transfer.model.ListedHostKey.ReadOnly {
    override val arn: Arn = zio.aws.transfer.model.primitives.Arn(impl.arn())
    override val hostKeyId: Optional[HostKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.hostKeyId())
      .map(value => zio.aws.transfer.model.primitives.HostKeyId(value))
    override val fingerprint: Optional[HostKeyFingerprint] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fingerprint())
        .map(value =>
          zio.aws.transfer.model.primitives.HostKeyFingerprint(value)
        )
    override val description: Optional[HostKeyDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.transfer.model.primitives.HostKeyDescription(value)
        )
    override val `type`: Optional[HostKeyType] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => zio.aws.transfer.model.primitives.HostKeyType(value))
    override val dateImported: Optional[DateImported] = zio.aws.core.internal
      .optionalFromNullable(impl.dateImported())
      .map(value => zio.aws.transfer.model.primitives.DateImported(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.ListedHostKey
  ): zio.aws.transfer.model.ListedHostKey.ReadOnly = new Wrapper(impl)
}
