package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{S3Key, S3Bucket}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class S3InputFileLocation(
    bucket: Optional[S3Bucket] = Optional.Absent,
    key: Optional[S3Key] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.S3InputFileLocation = {
    import S3InputFileLocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.S3InputFileLocation
      .builder()
      .optionallyWith(
        bucket.map(value => S3Bucket.unwrap(value): java.lang.String)
      )(_.bucket)
      .optionallyWith(key.map(value => S3Key.unwrap(value): java.lang.String))(
        _.key
      )
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.S3InputFileLocation.ReadOnly =
    zio.aws.transfer.model.S3InputFileLocation.wrap(buildAwsValue())
}
object S3InputFileLocation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.S3InputFileLocation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.S3InputFileLocation =
      zio.aws.transfer.model.S3InputFileLocation(
        bucket.map(value => value),
        key.map(value => value)
      )
    def bucket: Optional[S3Bucket]
    def key: Optional[S3Key]
    def getBucket: ZIO[Any, AwsError, S3Bucket] =
      AwsError.unwrapOptionField("bucket", bucket)
    def getKey: ZIO[Any, AwsError, S3Key] =
      AwsError.unwrapOptionField("key", key)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.S3InputFileLocation
  ) extends zio.aws.transfer.model.S3InputFileLocation.ReadOnly {
    override val bucket: Optional[S3Bucket] = zio.aws.core.internal
      .optionalFromNullable(impl.bucket())
      .map(value => zio.aws.transfer.model.primitives.S3Bucket(value))
    override val key: Optional[S3Key] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value => zio.aws.transfer.model.primitives.S3Key(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.S3InputFileLocation
  ): zio.aws.transfer.model.S3InputFileLocation.ReadOnly = new Wrapper(impl)
}
