package zio.aws.transfer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class S3StorageOptions(
    directoryListingOptimization: Optional[
      zio.aws.transfer.model.DirectoryListingOptimization
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.S3StorageOptions = {
    import S3StorageOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.S3StorageOptions
      .builder()
      .optionallyWith(directoryListingOptimization.map(value => value.unwrap))(
        _.directoryListingOptimization
      )
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.S3StorageOptions.ReadOnly =
    zio.aws.transfer.model.S3StorageOptions.wrap(buildAwsValue())
}
object S3StorageOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.S3StorageOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.S3StorageOptions =
      zio.aws.transfer.model
        .S3StorageOptions(directoryListingOptimization.map(value => value))
    def directoryListingOptimization
        : Optional[zio.aws.transfer.model.DirectoryListingOptimization]
    def getDirectoryListingOptimization: ZIO[
      Any,
      AwsError,
      zio.aws.transfer.model.DirectoryListingOptimization
    ] = AwsError.unwrapOptionField(
      "directoryListingOptimization",
      directoryListingOptimization
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.S3StorageOptions
  ) extends zio.aws.transfer.model.S3StorageOptions.ReadOnly {
    override val directoryListingOptimization
        : Optional[zio.aws.transfer.model.DirectoryListingOptimization] =
      zio.aws.core.internal
        .optionalFromNullable(impl.directoryListingOptimization())
        .map(value =>
          zio.aws.transfer.model.DirectoryListingOptimization.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.S3StorageOptions
  ): zio.aws.transfer.model.S3StorageOptions.ReadOnly = new Wrapper(impl)
}
