package zio.aws.transfer.model
import scala.jdk.CollectionConverters._
sealed trait SecurityPolicyProtocol {
  def unwrap
      : software.amazon.awssdk.services.transfer.model.SecurityPolicyProtocol
}
object SecurityPolicyProtocol {
  def wrap(
      value: software.amazon.awssdk.services.transfer.model.SecurityPolicyProtocol
  ): zio.aws.transfer.model.SecurityPolicyProtocol = value match {
    case software.amazon.awssdk.services.transfer.model.SecurityPolicyProtocol.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.transfer.model.SecurityPolicyProtocol.SFTP =>
      val r = SFTP
      r
    case software.amazon.awssdk.services.transfer.model.SecurityPolicyProtocol.FTPS =>
      val r = FTPS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.transfer.model.SecurityPolicyProtocol {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.SecurityPolicyProtocol =
      software.amazon.awssdk.services.transfer.model.SecurityPolicyProtocol.UNKNOWN_TO_SDK_VERSION
  }
  case object SFTP extends zio.aws.transfer.model.SecurityPolicyProtocol {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.SecurityPolicyProtocol =
      software.amazon.awssdk.services.transfer.model.SecurityPolicyProtocol.SFTP
  }
  case object FTPS extends zio.aws.transfer.model.SecurityPolicyProtocol {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.SecurityPolicyProtocol =
      software.amazon.awssdk.services.transfer.model.SecurityPolicyProtocol.FTPS
  }
}
