package zio.aws.transfer.model
import scala.jdk.CollectionConverters._
sealed trait SecurityPolicyResourceType {
  def unwrap: software.amazon.awssdk.services.transfer.model.SecurityPolicyResourceType
}
object SecurityPolicyResourceType {
  def wrap(
      value: software.amazon.awssdk.services.transfer.model.SecurityPolicyResourceType
  ): zio.aws.transfer.model.SecurityPolicyResourceType = value match {
    case software.amazon.awssdk.services.transfer.model.SecurityPolicyResourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.transfer.model.SecurityPolicyResourceType.SERVER =>
      val r = SERVER
      r
    case software.amazon.awssdk.services.transfer.model.SecurityPolicyResourceType.CONNECTOR =>
      val r = CONNECTOR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.transfer.model.SecurityPolicyResourceType {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.SecurityPolicyResourceType =
      software.amazon.awssdk.services.transfer.model.SecurityPolicyResourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object SERVER extends zio.aws.transfer.model.SecurityPolicyResourceType {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.SecurityPolicyResourceType =
      software.amazon.awssdk.services.transfer.model.SecurityPolicyResourceType.SERVER
  }
  case object CONNECTOR
      extends zio.aws.transfer.model.SecurityPolicyResourceType {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.SecurityPolicyResourceType =
      software.amazon.awssdk.services.transfer.model.SecurityPolicyResourceType.CONNECTOR
  }
}
