package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{SftpConnectorTrustedHostKey, SecretId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SftpConnectorConfig(
    userSecretId: Optional[SecretId] = Optional.Absent,
    trustedHostKeys: Optional[Iterable[SftpConnectorTrustedHostKey]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.SftpConnectorConfig = {
    import SftpConnectorConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.SftpConnectorConfig
      .builder()
      .optionallyWith(
        userSecretId.map(value => SecretId.unwrap(value): java.lang.String)
      )(_.userSecretId)
      .optionallyWith(
        trustedHostKeys.map(value =>
          value.map { item =>
            SftpConnectorTrustedHostKey.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.trustedHostKeys)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.SftpConnectorConfig.ReadOnly =
    zio.aws.transfer.model.SftpConnectorConfig.wrap(buildAwsValue())
}
object SftpConnectorConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.SftpConnectorConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.SftpConnectorConfig =
      zio.aws.transfer.model.SftpConnectorConfig(
        userSecretId.map(value => value),
        trustedHostKeys.map(value => value)
      )
    def userSecretId: Optional[SecretId]
    def trustedHostKeys: Optional[List[SftpConnectorTrustedHostKey]]
    def getUserSecretId: ZIO[Any, AwsError, SecretId] =
      AwsError.unwrapOptionField("userSecretId", userSecretId)
    def getTrustedHostKeys
        : ZIO[Any, AwsError, List[SftpConnectorTrustedHostKey]] =
      AwsError.unwrapOptionField("trustedHostKeys", trustedHostKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.SftpConnectorConfig
  ) extends zio.aws.transfer.model.SftpConnectorConfig.ReadOnly {
    override val userSecretId: Optional[SecretId] = zio.aws.core.internal
      .optionalFromNullable(impl.userSecretId())
      .map(value => zio.aws.transfer.model.primitives.SecretId(value))
    override val trustedHostKeys: Optional[List[SftpConnectorTrustedHostKey]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trustedHostKeys())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.transfer.model.primitives.SftpConnectorTrustedHostKey(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.SftpConnectorConfig
  ): zio.aws.transfer.model.SftpConnectorConfig.ReadOnly = new Wrapper(impl)
}
