package zio.aws.transfer.model
import scala.jdk.CollectionConverters._
sealed trait SigningAlg {
  def unwrap: software.amazon.awssdk.services.transfer.model.SigningAlg
}
object SigningAlg {
  def wrap(
      value: software.amazon.awssdk.services.transfer.model.SigningAlg
  ): zio.aws.transfer.model.SigningAlg = value match {
    case software.amazon.awssdk.services.transfer.model.SigningAlg.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.transfer.model.SigningAlg.SHA256 =>
      val r = SHA256
      r
    case software.amazon.awssdk.services.transfer.model.SigningAlg.SHA384 =>
      val r = SHA384
      r
    case software.amazon.awssdk.services.transfer.model.SigningAlg.SHA512 =>
      val r = SHA512
      r
    case software.amazon.awssdk.services.transfer.model.SigningAlg.SHA1 =>
      val r = SHA1
      r
    case software.amazon.awssdk.services.transfer.model.SigningAlg.NONE =>
      val r = NONE
      r
  }
  case object unknownToSdkVersion extends zio.aws.transfer.model.SigningAlg {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.SigningAlg =
      software.amazon.awssdk.services.transfer.model.SigningAlg.UNKNOWN_TO_SDK_VERSION
  }
  case object SHA256 extends zio.aws.transfer.model.SigningAlg {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.SigningAlg =
      software.amazon.awssdk.services.transfer.model.SigningAlg.SHA256
  }
  case object SHA384 extends zio.aws.transfer.model.SigningAlg {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.SigningAlg =
      software.amazon.awssdk.services.transfer.model.SigningAlg.SHA384
  }
  case object SHA512 extends zio.aws.transfer.model.SigningAlg {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.SigningAlg =
      software.amazon.awssdk.services.transfer.model.SigningAlg.SHA512
  }
  case object SHA1 extends zio.aws.transfer.model.SigningAlg {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.SigningAlg =
      software.amazon.awssdk.services.transfer.model.SigningAlg.SHA1
  }
  case object NONE extends zio.aws.transfer.model.SigningAlg {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.SigningAlg =
      software.amazon.awssdk.services.transfer.model.SigningAlg.NONE
  }
}
