package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{OutputFileName, ListingId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StartDirectoryListingResponse(
    listingId: ListingId,
    outputFileName: OutputFileName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.StartDirectoryListingResponse = {
    import StartDirectoryListingResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.StartDirectoryListingResponse
      .builder()
      .listingId(ListingId.unwrap(listingId): java.lang.String)
      .outputFileName(OutputFileName.unwrap(outputFileName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.transfer.model.StartDirectoryListingResponse.ReadOnly =
    zio.aws.transfer.model.StartDirectoryListingResponse.wrap(buildAwsValue())
}
object StartDirectoryListingResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.StartDirectoryListingResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.StartDirectoryListingResponse =
      zio.aws.transfer.model
        .StartDirectoryListingResponse(listingId, outputFileName)
    def listingId: ListingId
    def outputFileName: OutputFileName
    def getListingId: ZIO[Any, Nothing, ListingId] = ZIO.succeed(listingId)
    def getOutputFileName: ZIO[Any, Nothing, OutputFileName] =
      ZIO.succeed(outputFileName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.StartDirectoryListingResponse
  ) extends zio.aws.transfer.model.StartDirectoryListingResponse.ReadOnly {
    override val listingId: ListingId =
      zio.aws.transfer.model.primitives.ListingId(impl.listingId())
    override val outputFileName: OutputFileName =
      zio.aws.transfer.model.primitives.OutputFileName(impl.outputFileName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.StartDirectoryListingResponse
  ): zio.aws.transfer.model.StartDirectoryListingResponse.ReadOnly =
    new Wrapper(impl)
}
