package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{FilePath, ConnectorId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartFileTransferRequest(
    connectorId: ConnectorId,
    sendFilePaths: Optional[Iterable[FilePath]] = Optional.Absent,
    retrieveFilePaths: Optional[Iterable[FilePath]] = Optional.Absent,
    localDirectoryPath: Optional[FilePath] = Optional.Absent,
    remoteDirectoryPath: Optional[FilePath] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.StartFileTransferRequest = {
    import StartFileTransferRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.StartFileTransferRequest
      .builder()
      .connectorId(ConnectorId.unwrap(connectorId): java.lang.String)
      .optionallyWith(
        sendFilePaths.map(value =>
          value.map { item =>
            FilePath.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.sendFilePaths)
      .optionallyWith(
        retrieveFilePaths.map(value =>
          value.map { item =>
            FilePath.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.retrieveFilePaths)
      .optionallyWith(
        localDirectoryPath.map(value =>
          FilePath.unwrap(value): java.lang.String
        )
      )(_.localDirectoryPath)
      .optionallyWith(
        remoteDirectoryPath.map(value =>
          FilePath.unwrap(value): java.lang.String
        )
      )(_.remoteDirectoryPath)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.StartFileTransferRequest.ReadOnly =
    zio.aws.transfer.model.StartFileTransferRequest.wrap(buildAwsValue())
}
object StartFileTransferRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.StartFileTransferRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.StartFileTransferRequest =
      zio.aws.transfer.model.StartFileTransferRequest(
        connectorId,
        sendFilePaths.map(value => value),
        retrieveFilePaths.map(value => value),
        localDirectoryPath.map(value => value),
        remoteDirectoryPath.map(value => value)
      )
    def connectorId: ConnectorId
    def sendFilePaths: Optional[List[FilePath]]
    def retrieveFilePaths: Optional[List[FilePath]]
    def localDirectoryPath: Optional[FilePath]
    def remoteDirectoryPath: Optional[FilePath]
    def getConnectorId: ZIO[Any, Nothing, ConnectorId] =
      ZIO.succeed(connectorId)
    def getSendFilePaths: ZIO[Any, AwsError, List[FilePath]] =
      AwsError.unwrapOptionField("sendFilePaths", sendFilePaths)
    def getRetrieveFilePaths: ZIO[Any, AwsError, List[FilePath]] =
      AwsError.unwrapOptionField("retrieveFilePaths", retrieveFilePaths)
    def getLocalDirectoryPath: ZIO[Any, AwsError, FilePath] =
      AwsError.unwrapOptionField("localDirectoryPath", localDirectoryPath)
    def getRemoteDirectoryPath: ZIO[Any, AwsError, FilePath] =
      AwsError.unwrapOptionField("remoteDirectoryPath", remoteDirectoryPath)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.StartFileTransferRequest
  ) extends zio.aws.transfer.model.StartFileTransferRequest.ReadOnly {
    override val connectorId: ConnectorId =
      zio.aws.transfer.model.primitives.ConnectorId(impl.connectorId())
    override val sendFilePaths: Optional[List[FilePath]] = zio.aws.core.internal
      .optionalFromNullable(impl.sendFilePaths())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.transfer.model.primitives.FilePath(item)
        }.toList
      )
    override val retrieveFilePaths: Optional[List[FilePath]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retrieveFilePaths())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.transfer.model.primitives.FilePath(item)
          }.toList
        )
    override val localDirectoryPath: Optional[FilePath] = zio.aws.core.internal
      .optionalFromNullable(impl.localDirectoryPath())
      .map(value => zio.aws.transfer.model.primitives.FilePath(value))
    override val remoteDirectoryPath: Optional[FilePath] = zio.aws.core.internal
      .optionalFromNullable(impl.remoteDirectoryPath())
      .map(value => zio.aws.transfer.model.primitives.FilePath(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.StartFileTransferRequest
  ): zio.aws.transfer.model.StartFileTransferRequest.ReadOnly = new Wrapper(
    impl
  )
}
