package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.ServerId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StopServerRequest(serverId: ServerId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.StopServerRequest = {
    import StopServerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.StopServerRequest
      .builder()
      .serverId(ServerId.unwrap(serverId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.StopServerRequest.ReadOnly =
    zio.aws.transfer.model.StopServerRequest.wrap(buildAwsValue())
}
object StopServerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.StopServerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.StopServerRequest =
      zio.aws.transfer.model.StopServerRequest(serverId)
    def serverId: ServerId
    def getServerId: ZIO[Any, Nothing, ServerId] = ZIO.succeed(serverId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.StopServerRequest
  ) extends zio.aws.transfer.model.StopServerRequest.ReadOnly {
    override val serverId: ServerId =
      zio.aws.transfer.model.primitives.ServerId(impl.serverId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.StopServerRequest
  ): zio.aws.transfer.model.StopServerRequest.ReadOnly = new Wrapper(impl)
}
