package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{Message, Status, ConnectorId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TestConnectionResponse(
    connectorId: Optional[ConnectorId] = Optional.Absent,
    status: Optional[Status] = Optional.Absent,
    statusMessage: Optional[Message] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.TestConnectionResponse = {
    import TestConnectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.TestConnectionResponse
      .builder()
      .optionallyWith(
        connectorId.map(value => ConnectorId.unwrap(value): java.lang.String)
      )(_.connectorId)
      .optionallyWith(
        status.map(value => Status.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        statusMessage.map(value => Message.unwrap(value): java.lang.String)
      )(_.statusMessage)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.TestConnectionResponse.ReadOnly =
    zio.aws.transfer.model.TestConnectionResponse.wrap(buildAwsValue())
}
object TestConnectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.TestConnectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.TestConnectionResponse =
      zio.aws.transfer.model.TestConnectionResponse(
        connectorId.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value)
      )
    def connectorId: Optional[ConnectorId]
    def status: Optional[Status]
    def statusMessage: Optional[Message]
    def getConnectorId: ZIO[Any, AwsError, ConnectorId] =
      AwsError.unwrapOptionField("connectorId", connectorId)
    def getStatus: ZIO[Any, AwsError, Status] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.TestConnectionResponse
  ) extends zio.aws.transfer.model.TestConnectionResponse.ReadOnly {
    override val connectorId: Optional[ConnectorId] = zio.aws.core.internal
      .optionalFromNullable(impl.connectorId())
      .map(value => zio.aws.transfer.model.primitives.ConnectorId(value))
    override val status: Optional[Status] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.transfer.model.primitives.Status(value))
    override val statusMessage: Optional[Message] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => zio.aws.transfer.model.primitives.Message(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.TestConnectionResponse
  ): zio.aws.transfer.model.TestConnectionResponse.ReadOnly = new Wrapper(impl)
}
