package zio.aws.transfer.model
import scala.jdk.CollectionConverters._
sealed trait TransferTableStatus {
  def unwrap: software.amazon.awssdk.services.transfer.model.TransferTableStatus
}
object TransferTableStatus {
  def wrap(
      value: software.amazon.awssdk.services.transfer.model.TransferTableStatus
  ): zio.aws.transfer.model.TransferTableStatus = value match {
    case software.amazon.awssdk.services.transfer.model.TransferTableStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.transfer.model.TransferTableStatus.QUEUED =>
      val r = QUEUED
      r
    case software.amazon.awssdk.services.transfer.model.TransferTableStatus.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.transfer.model.TransferTableStatus.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.transfer.model.TransferTableStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.transfer.model.TransferTableStatus {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.TransferTableStatus =
      software.amazon.awssdk.services.transfer.model.TransferTableStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object QUEUED extends zio.aws.transfer.model.TransferTableStatus {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.TransferTableStatus =
      software.amazon.awssdk.services.transfer.model.TransferTableStatus.QUEUED
  }
  case object IN_PROGRESS extends zio.aws.transfer.model.TransferTableStatus {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.TransferTableStatus =
      software.amazon.awssdk.services.transfer.model.TransferTableStatus.IN_PROGRESS
  }
  case object COMPLETED extends zio.aws.transfer.model.TransferTableStatus {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.TransferTableStatus =
      software.amazon.awssdk.services.transfer.model.TransferTableStatus.COMPLETED
  }
  case object FAILED extends zio.aws.transfer.model.TransferTableStatus {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.TransferTableStatus =
      software.amazon.awssdk.services.transfer.model.TransferTableStatus.FAILED
  }
}
