package zio.aws.transfer.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.transfer.model.primitives.{Description, CertDate, CertificateId}
import scala.jdk.CollectionConverters._
final case class UpdateCertificateRequest(
    certificateId: CertificateId,
    activeDate: Optional[CertDate] = Optional.Absent,
    inactiveDate: Optional[CertDate] = Optional.Absent,
    description: Optional[Description] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.UpdateCertificateRequest = {
    import UpdateCertificateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.UpdateCertificateRequest
      .builder()
      .certificateId(CertificateId.unwrap(certificateId): java.lang.String)
      .optionallyWith(activeDate.map(value => CertDate.unwrap(value): Instant))(
        _.activeDate
      )
      .optionallyWith(
        inactiveDate.map(value => CertDate.unwrap(value): Instant)
      )(_.inactiveDate)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.UpdateCertificateRequest.ReadOnly =
    zio.aws.transfer.model.UpdateCertificateRequest.wrap(buildAwsValue())
}
object UpdateCertificateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.UpdateCertificateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.UpdateCertificateRequest =
      zio.aws.transfer.model.UpdateCertificateRequest(
        certificateId,
        activeDate.map(value => value),
        inactiveDate.map(value => value),
        description.map(value => value)
      )
    def certificateId: CertificateId
    def activeDate: Optional[CertDate]
    def inactiveDate: Optional[CertDate]
    def description: Optional[Description]
    def getCertificateId: ZIO[Any, Nothing, CertificateId] =
      ZIO.succeed(certificateId)
    def getActiveDate: ZIO[Any, AwsError, CertDate] =
      AwsError.unwrapOptionField("activeDate", activeDate)
    def getInactiveDate: ZIO[Any, AwsError, CertDate] =
      AwsError.unwrapOptionField("inactiveDate", inactiveDate)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.UpdateCertificateRequest
  ) extends zio.aws.transfer.model.UpdateCertificateRequest.ReadOnly {
    override val certificateId: CertificateId =
      zio.aws.transfer.model.primitives.CertificateId(impl.certificateId())
    override val activeDate: Optional[CertDate] = zio.aws.core.internal
      .optionalFromNullable(impl.activeDate())
      .map(value => zio.aws.transfer.model.primitives.CertDate(value))
    override val inactiveDate: Optional[CertDate] = zio.aws.core.internal
      .optionalFromNullable(impl.inactiveDate())
      .map(value => zio.aws.transfer.model.primitives.CertDate(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.transfer.model.primitives.Description(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.UpdateCertificateRequest
  ): zio.aws.transfer.model.UpdateCertificateRequest.ReadOnly = new Wrapper(
    impl
  )
}
