package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.CertificateId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateCertificateResponse(certificateId: CertificateId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.UpdateCertificateResponse = {
    import UpdateCertificateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.UpdateCertificateResponse
      .builder()
      .certificateId(CertificateId.unwrap(certificateId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.UpdateCertificateResponse.ReadOnly =
    zio.aws.transfer.model.UpdateCertificateResponse.wrap(buildAwsValue())
}
object UpdateCertificateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.UpdateCertificateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.UpdateCertificateResponse =
      zio.aws.transfer.model.UpdateCertificateResponse(certificateId)
    def certificateId: CertificateId
    def getCertificateId: ZIO[Any, Nothing, CertificateId] =
      ZIO.succeed(certificateId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.UpdateCertificateResponse
  ) extends zio.aws.transfer.model.UpdateCertificateResponse.ReadOnly {
    override val certificateId: CertificateId =
      zio.aws.transfer.model.primitives.CertificateId(impl.certificateId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.UpdateCertificateResponse
  ): zio.aws.transfer.model.UpdateCertificateResponse.ReadOnly = new Wrapper(
    impl
  )
}
