package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{
  ConnectorSecurityPolicyName,
  Role,
  Url,
  ConnectorId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateConnectorRequest(
    connectorId: ConnectorId,
    url: Optional[Url] = Optional.Absent,
    as2Config: Optional[zio.aws.transfer.model.As2ConnectorConfig] =
      Optional.Absent,
    accessRole: Optional[Role] = Optional.Absent,
    loggingRole: Optional[Role] = Optional.Absent,
    sftpConfig: Optional[zio.aws.transfer.model.SftpConnectorConfig] =
      Optional.Absent,
    securityPolicyName: Optional[ConnectorSecurityPolicyName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.UpdateConnectorRequest = {
    import UpdateConnectorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.UpdateConnectorRequest
      .builder()
      .connectorId(ConnectorId.unwrap(connectorId): java.lang.String)
      .optionallyWith(url.map(value => Url.unwrap(value): java.lang.String))(
        _.url
      )
      .optionallyWith(as2Config.map(value => value.buildAwsValue()))(
        _.as2Config
      )
      .optionallyWith(
        accessRole.map(value => Role.unwrap(value): java.lang.String)
      )(_.accessRole)
      .optionallyWith(
        loggingRole.map(value => Role.unwrap(value): java.lang.String)
      )(_.loggingRole)
      .optionallyWith(sftpConfig.map(value => value.buildAwsValue()))(
        _.sftpConfig
      )
      .optionallyWith(
        securityPolicyName.map(value =>
          ConnectorSecurityPolicyName.unwrap(value): java.lang.String
        )
      )(_.securityPolicyName)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.UpdateConnectorRequest.ReadOnly =
    zio.aws.transfer.model.UpdateConnectorRequest.wrap(buildAwsValue())
}
object UpdateConnectorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.UpdateConnectorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.UpdateConnectorRequest =
      zio.aws.transfer.model.UpdateConnectorRequest(
        connectorId,
        url.map(value => value),
        as2Config.map(value => value.asEditable),
        accessRole.map(value => value),
        loggingRole.map(value => value),
        sftpConfig.map(value => value.asEditable),
        securityPolicyName.map(value => value)
      )
    def connectorId: ConnectorId
    def url: Optional[Url]
    def as2Config: Optional[zio.aws.transfer.model.As2ConnectorConfig.ReadOnly]
    def accessRole: Optional[Role]
    def loggingRole: Optional[Role]
    def sftpConfig
        : Optional[zio.aws.transfer.model.SftpConnectorConfig.ReadOnly]
    def securityPolicyName: Optional[ConnectorSecurityPolicyName]
    def getConnectorId: ZIO[Any, Nothing, ConnectorId] =
      ZIO.succeed(connectorId)
    def getUrl: ZIO[Any, AwsError, Url] = AwsError.unwrapOptionField("url", url)
    def getAs2Config: ZIO[
      Any,
      AwsError,
      zio.aws.transfer.model.As2ConnectorConfig.ReadOnly
    ] = AwsError.unwrapOptionField("as2Config", as2Config)
    def getAccessRole: ZIO[Any, AwsError, Role] =
      AwsError.unwrapOptionField("accessRole", accessRole)
    def getLoggingRole: ZIO[Any, AwsError, Role] =
      AwsError.unwrapOptionField("loggingRole", loggingRole)
    def getSftpConfig: ZIO[
      Any,
      AwsError,
      zio.aws.transfer.model.SftpConnectorConfig.ReadOnly
    ] = AwsError.unwrapOptionField("sftpConfig", sftpConfig)
    def getSecurityPolicyName: ZIO[Any, AwsError, ConnectorSecurityPolicyName] =
      AwsError.unwrapOptionField("securityPolicyName", securityPolicyName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.UpdateConnectorRequest
  ) extends zio.aws.transfer.model.UpdateConnectorRequest.ReadOnly {
    override val connectorId: ConnectorId =
      zio.aws.transfer.model.primitives.ConnectorId(impl.connectorId())
    override val url: Optional[Url] = zio.aws.core.internal
      .optionalFromNullable(impl.url())
      .map(value => zio.aws.transfer.model.primitives.Url(value))
    override val as2Config
        : Optional[zio.aws.transfer.model.As2ConnectorConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.as2Config())
        .map(value => zio.aws.transfer.model.As2ConnectorConfig.wrap(value))
    override val accessRole: Optional[Role] = zio.aws.core.internal
      .optionalFromNullable(impl.accessRole())
      .map(value => zio.aws.transfer.model.primitives.Role(value))
    override val loggingRole: Optional[Role] = zio.aws.core.internal
      .optionalFromNullable(impl.loggingRole())
      .map(value => zio.aws.transfer.model.primitives.Role(value))
    override val sftpConfig
        : Optional[zio.aws.transfer.model.SftpConnectorConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sftpConfig())
        .map(value => zio.aws.transfer.model.SftpConnectorConfig.wrap(value))
    override val securityPolicyName: Optional[ConnectorSecurityPolicyName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityPolicyName())
        .map(value =>
          zio.aws.transfer.model.primitives.ConnectorSecurityPolicyName(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.UpdateConnectorRequest
  ): zio.aws.transfer.model.UpdateConnectorRequest.ReadOnly = new Wrapper(impl)
}
