package zio.aws.transfer.model
import zio.aws.transfer.model.primitives.{Role, WorkflowId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class WorkflowDetail(workflowId: WorkflowId, executionRole: Role) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.WorkflowDetail = {
    import WorkflowDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.WorkflowDetail
      .builder()
      .workflowId(WorkflowId.unwrap(workflowId): java.lang.String)
      .executionRole(Role.unwrap(executionRole): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.WorkflowDetail.ReadOnly =
    zio.aws.transfer.model.WorkflowDetail.wrap(buildAwsValue())
}
object WorkflowDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.WorkflowDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.WorkflowDetail =
      zio.aws.transfer.model.WorkflowDetail(workflowId, executionRole)
    def workflowId: WorkflowId
    def executionRole: Role
    def getWorkflowId: ZIO[Any, Nothing, WorkflowId] = ZIO.succeed(workflowId)
    def getExecutionRole: ZIO[Any, Nothing, Role] = ZIO.succeed(executionRole)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.WorkflowDetail
  ) extends zio.aws.transfer.model.WorkflowDetail.ReadOnly {
    override val workflowId: WorkflowId =
      zio.aws.transfer.model.primitives.WorkflowId(impl.workflowId())
    override val executionRole: Role =
      zio.aws.transfer.model.primitives.Role(impl.executionRole())
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.WorkflowDetail
  ): zio.aws.transfer.model.WorkflowDetail.ReadOnly = new Wrapper(impl)
}
