package zio.aws.transfer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class WorkflowDetails(
    onUpload: Optional[Iterable[zio.aws.transfer.model.WorkflowDetail]] =
      Optional.Absent,
    onPartialUpload: Optional[Iterable[zio.aws.transfer.model.WorkflowDetail]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.transfer.model.WorkflowDetails = {
    import WorkflowDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.transfer.model.WorkflowDetails
      .builder()
      .optionallyWith(
        onUpload.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.onUpload)
      .optionallyWith(
        onPartialUpload.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.onPartialUpload)
      .build()
  }
  def asReadOnly: zio.aws.transfer.model.WorkflowDetails.ReadOnly =
    zio.aws.transfer.model.WorkflowDetails.wrap(buildAwsValue())
}
object WorkflowDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.transfer.model.WorkflowDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.transfer.model.WorkflowDetails =
      zio.aws.transfer.model.WorkflowDetails(
        onUpload.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        onPartialUpload.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def onUpload: Optional[List[zio.aws.transfer.model.WorkflowDetail.ReadOnly]]
    def onPartialUpload
        : Optional[List[zio.aws.transfer.model.WorkflowDetail.ReadOnly]]
    def getOnUpload: ZIO[Any, AwsError, List[
      zio.aws.transfer.model.WorkflowDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("onUpload", onUpload)
    def getOnPartialUpload: ZIO[Any, AwsError, List[
      zio.aws.transfer.model.WorkflowDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("onPartialUpload", onPartialUpload)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.transfer.model.WorkflowDetails
  ) extends zio.aws.transfer.model.WorkflowDetails.ReadOnly {
    override val onUpload
        : Optional[List[zio.aws.transfer.model.WorkflowDetail.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.onUpload())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.transfer.model.WorkflowDetail.wrap(item)
          }.toList
        )
    override val onPartialUpload
        : Optional[List[zio.aws.transfer.model.WorkflowDetail.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.onPartialUpload())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.transfer.model.WorkflowDetail.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.transfer.model.WorkflowDetails
  ): zio.aws.transfer.model.WorkflowDetails.ReadOnly = new Wrapper(impl)
}
