package zio.aws.transfer.model
import scala.jdk.CollectionConverters._
sealed trait WorkflowStepType {
  def unwrap: software.amazon.awssdk.services.transfer.model.WorkflowStepType
}
object WorkflowStepType {
  def wrap(
      value: software.amazon.awssdk.services.transfer.model.WorkflowStepType
  ): zio.aws.transfer.model.WorkflowStepType = value match {
    case software.amazon.awssdk.services.transfer.model.WorkflowStepType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.transfer.model.WorkflowStepType.COPY =>
      val r = COPY
      r
    case software.amazon.awssdk.services.transfer.model.WorkflowStepType.CUSTOM =>
      val r = CUSTOM
      r
    case software.amazon.awssdk.services.transfer.model.WorkflowStepType.TAG =>
      val r = TAG
      r
    case software.amazon.awssdk.services.transfer.model.WorkflowStepType.DELETE =>
      val r = DELETE
      r
    case software.amazon.awssdk.services.transfer.model.WorkflowStepType.DECRYPT =>
      val r = DECRYPT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.transfer.model.WorkflowStepType {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.WorkflowStepType =
      software.amazon.awssdk.services.transfer.model.WorkflowStepType.UNKNOWN_TO_SDK_VERSION
  }
  case object COPY extends zio.aws.transfer.model.WorkflowStepType {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.WorkflowStepType =
      software.amazon.awssdk.services.transfer.model.WorkflowStepType.COPY
  }
  case object CUSTOM extends zio.aws.transfer.model.WorkflowStepType {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.WorkflowStepType =
      software.amazon.awssdk.services.transfer.model.WorkflowStepType.CUSTOM
  }
  case object TAG extends zio.aws.transfer.model.WorkflowStepType {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.WorkflowStepType =
      software.amazon.awssdk.services.transfer.model.WorkflowStepType.TAG
  }
  case object DELETE extends zio.aws.transfer.model.WorkflowStepType {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.WorkflowStepType =
      software.amazon.awssdk.services.transfer.model.WorkflowStepType.DELETE
  }
  case object DECRYPT extends zio.aws.transfer.model.WorkflowStepType {
    override def unwrap
        : software.amazon.awssdk.services.transfer.model.WorkflowStepType =
      software.amazon.awssdk.services.transfer.model.WorkflowStepType.DECRYPT
  }
}
