package zio.aws.transfer
import zio.aws.transfer.model.primitives.{
  SubnetId,
  SecurityPolicyOption,
  SecurityGroupId,
  AddressAllocationId,
  PosixId,
  ServiceManagedEgressIpAddress,
  Arn,
  CertificateId,
  FilePath,
  SftpConnectorTrustedHostKey,
  SecurityPolicyName,
  TagKey
}
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.transfer.model.primitives.HomeDirectory.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object AddressAllocationId extends zio.prelude.Subtype[String]
    type AddressAllocationId =
      zio.aws.transfer.model.primitives.AddressAllocationId.Type
    object AgreementId extends zio.prelude.Subtype[String]
    type AgreementId = zio.aws.transfer.model.primitives.AgreementId.Type
    object Arn extends zio.prelude.Subtype[String]
    type Arn = zio.aws.transfer.model.primitives.Arn.Type
    object As2ConnectorSecretId extends zio.prelude.Subtype[String]
    type As2ConnectorSecretId =
      zio.aws.transfer.model.primitives.As2ConnectorSecretId.Type
    object As2Id extends zio.prelude.Subtype[String]
    type As2Id = zio.aws.transfer.model.primitives.As2Id.Type
    object CallbackToken extends zio.prelude.Subtype[String]
    type CallbackToken = zio.aws.transfer.model.primitives.CallbackToken.Type
    object CertDate extends zio.prelude.Subtype[Instant]
    type CertDate = zio.aws.transfer.model.primitives.CertDate.Type
    object CertSerial extends zio.prelude.Subtype[String]
    type CertSerial = zio.aws.transfer.model.primitives.CertSerial.Type
    object Certificate extends zio.prelude.Subtype[String]
    type Certificate = zio.aws.transfer.model.primitives.Certificate.Type
    object CertificateBodyType extends zio.prelude.Subtype[String]
    type CertificateBodyType =
      zio.aws.transfer.model.primitives.CertificateBodyType.Type
    object CertificateChainType extends zio.prelude.Subtype[String]
    type CertificateChainType =
      zio.aws.transfer.model.primitives.CertificateChainType.Type
    object CertificateId extends zio.prelude.Subtype[String]
    type CertificateId = zio.aws.transfer.model.primitives.CertificateId.Type
    object ConnectorId extends zio.prelude.Subtype[String]
    type ConnectorId = zio.aws.transfer.model.primitives.ConnectorId.Type
    object ConnectorSecurityPolicyName extends zio.prelude.Subtype[String]
    type ConnectorSecurityPolicyName =
      zio.aws.transfer.model.primitives.ConnectorSecurityPolicyName.Type
    object CustomStepTarget extends zio.prelude.Subtype[String]
    type CustomStepTarget =
      zio.aws.transfer.model.primitives.CustomStepTarget.Type
    object CustomStepTimeoutSeconds extends zio.prelude.Subtype[Int]
    type CustomStepTimeoutSeconds =
      zio.aws.transfer.model.primitives.CustomStepTimeoutSeconds.Type
    object DateImported extends zio.prelude.Subtype[Instant]
    type DateImported = zio.aws.transfer.model.primitives.DateImported.Type
    object Description extends zio.prelude.Subtype[String]
    type Description = zio.aws.transfer.model.primitives.Description.Type
    object DirectoryId extends zio.prelude.Subtype[String]
    type DirectoryId = zio.aws.transfer.model.primitives.DirectoryId.Type
    object EfsFileSystemId extends zio.prelude.Subtype[String]
    type EfsFileSystemId =
      zio.aws.transfer.model.primitives.EfsFileSystemId.Type
    object EfsPath extends zio.prelude.Subtype[String]
    type EfsPath = zio.aws.transfer.model.primitives.EfsPath.Type
    object ExecutionErrorMessage extends zio.prelude.Subtype[String]
    type ExecutionErrorMessage =
      zio.aws.transfer.model.primitives.ExecutionErrorMessage.Type
    object ExecutionId extends zio.prelude.Subtype[String]
    type ExecutionId = zio.aws.transfer.model.primitives.ExecutionId.Type
    object ExternalId extends zio.prelude.Subtype[String]
    type ExternalId = zio.aws.transfer.model.primitives.ExternalId.Type
    object FailureCode extends zio.prelude.Subtype[String]
    type FailureCode = zio.aws.transfer.model.primitives.FailureCode.Type
    object FilePath extends zio.prelude.Subtype[String]
    type FilePath = zio.aws.transfer.model.primitives.FilePath.Type
    object Fips extends zio.prelude.Subtype[Boolean]
    type Fips = zio.aws.transfer.model.primitives.Fips.Type
    object Function extends zio.prelude.Subtype[String]
    type Function = zio.aws.transfer.model.primitives.Function.Type
    object HomeDirectory extends zio.prelude.Subtype[String]
    type HomeDirectory = zio.aws.transfer.model.primitives.HomeDirectory.Type
    object HostKey extends zio.prelude.Subtype[String]
    type HostKey = zio.aws.transfer.model.primitives.HostKey.Type
    object HostKeyDescription extends zio.prelude.Subtype[String]
    type HostKeyDescription =
      zio.aws.transfer.model.primitives.HostKeyDescription.Type
    object HostKeyFingerprint extends zio.prelude.Subtype[String]
    type HostKeyFingerprint =
      zio.aws.transfer.model.primitives.HostKeyFingerprint.Type
    object HostKeyId extends zio.prelude.Subtype[String]
    type HostKeyId = zio.aws.transfer.model.primitives.HostKeyId.Type
    object HostKeyType extends zio.prelude.Subtype[String]
    type HostKeyType = zio.aws.transfer.model.primitives.HostKeyType.Type
    object ListingId extends zio.prelude.Subtype[String]
    type ListingId = zio.aws.transfer.model.primitives.ListingId.Type
    object LogGroupName extends zio.prelude.Subtype[String]
    type LogGroupName = zio.aws.transfer.model.primitives.LogGroupName.Type
    object MapEntry extends zio.prelude.Subtype[String]
    type MapEntry = zio.aws.transfer.model.primitives.MapEntry.Type
    object MapTarget extends zio.prelude.Subtype[String]
    type MapTarget = zio.aws.transfer.model.primitives.MapTarget.Type
    object MaxItems extends zio.prelude.Subtype[Int]
    type MaxItems = zio.aws.transfer.model.primitives.MaxItems.Type
    object MaxResults extends zio.prelude.Subtype[Int]
    type MaxResults = zio.aws.transfer.model.primitives.MaxResults.Type
    object Message extends zio.prelude.Subtype[String]
    type Message = zio.aws.transfer.model.primitives.Message.Type
    object MessageSubject extends zio.prelude.Subtype[String]
    type MessageSubject = zio.aws.transfer.model.primitives.MessageSubject.Type
    object NextToken extends zio.prelude.Subtype[String]
    type NextToken = zio.aws.transfer.model.primitives.NextToken.Type
    object NullableRole extends zio.prelude.Subtype[String]
    type NullableRole = zio.aws.transfer.model.primitives.NullableRole.Type
    object OutputFileName extends zio.prelude.Subtype[String]
    type OutputFileName = zio.aws.transfer.model.primitives.OutputFileName.Type
    object PassiveIp extends zio.prelude.Subtype[String]
    type PassiveIp = zio.aws.transfer.model.primitives.PassiveIp.Type
    object Policy extends zio.prelude.Subtype[String]
    type Policy = zio.aws.transfer.model.primitives.Policy.Type
    object PosixId extends zio.prelude.Subtype[Long]
    type PosixId = zio.aws.transfer.model.primitives.PosixId.Type
    object PostAuthenticationLoginBanner extends zio.prelude.Subtype[String]
    type PostAuthenticationLoginBanner =
      zio.aws.transfer.model.primitives.PostAuthenticationLoginBanner.Type
    object PreAuthenticationLoginBanner extends zio.prelude.Subtype[String]
    type PreAuthenticationLoginBanner =
      zio.aws.transfer.model.primitives.PreAuthenticationLoginBanner.Type
    object PrivateKeyType extends zio.prelude.Subtype[String]
    type PrivateKeyType = zio.aws.transfer.model.primitives.PrivateKeyType.Type
    object ProfileId extends zio.prelude.Subtype[String]
    type ProfileId = zio.aws.transfer.model.primitives.ProfileId.Type
    object Response extends zio.prelude.Subtype[String]
    type Response = zio.aws.transfer.model.primitives.Response.Type
    object Role extends zio.prelude.Subtype[String]
    type Role = zio.aws.transfer.model.primitives.Role.Type
    object S3Bucket extends zio.prelude.Subtype[String]
    type S3Bucket = zio.aws.transfer.model.primitives.S3Bucket.Type
    object S3Etag extends zio.prelude.Subtype[String]
    type S3Etag = zio.aws.transfer.model.primitives.S3Etag.Type
    object S3Key extends zio.prelude.Subtype[String]
    type S3Key = zio.aws.transfer.model.primitives.S3Key.Type
    object S3TagKey extends zio.prelude.Subtype[String]
    type S3TagKey = zio.aws.transfer.model.primitives.S3TagKey.Type
    object S3TagValue extends zio.prelude.Subtype[String]
    type S3TagValue = zio.aws.transfer.model.primitives.S3TagValue.Type
    object S3VersionId extends zio.prelude.Subtype[String]
    type S3VersionId = zio.aws.transfer.model.primitives.S3VersionId.Type
    object SecretId extends zio.prelude.Subtype[String]
    type SecretId = zio.aws.transfer.model.primitives.SecretId.Type
    object SecurityGroupId extends zio.prelude.Subtype[String]
    type SecurityGroupId =
      zio.aws.transfer.model.primitives.SecurityGroupId.Type
    object SecurityPolicyName extends zio.prelude.Subtype[String]
    type SecurityPolicyName =
      zio.aws.transfer.model.primitives.SecurityPolicyName.Type
    object SecurityPolicyOption extends zio.prelude.Subtype[String]
    type SecurityPolicyOption =
      zio.aws.transfer.model.primitives.SecurityPolicyOption.Type
    object ServerId extends zio.prelude.Subtype[String]
    type ServerId = zio.aws.transfer.model.primitives.ServerId.Type
    object ServiceManagedEgressIpAddress extends zio.prelude.Subtype[String]
    type ServiceManagedEgressIpAddress =
      zio.aws.transfer.model.primitives.ServiceManagedEgressIpAddress.Type
    object SessionId extends zio.prelude.Subtype[String]
    type SessionId = zio.aws.transfer.model.primitives.SessionId.Type
    object SftpConnectorTrustedHostKey extends zio.prelude.Subtype[String]
    type SftpConnectorTrustedHostKey =
      zio.aws.transfer.model.primitives.SftpConnectorTrustedHostKey.Type
    object SourceFileLocation extends zio.prelude.Subtype[String]
    type SourceFileLocation =
      zio.aws.transfer.model.primitives.SourceFileLocation.Type
    object SourceIp extends zio.prelude.Subtype[String]
    type SourceIp = zio.aws.transfer.model.primitives.SourceIp.Type
    object SshPublicKeyBody extends zio.prelude.Subtype[String]
    type SshPublicKeyBody =
      zio.aws.transfer.model.primitives.SshPublicKeyBody.Type
    object SshPublicKeyCount extends zio.prelude.Subtype[Int]
    type SshPublicKeyCount =
      zio.aws.transfer.model.primitives.SshPublicKeyCount.Type
    object SshPublicKeyId extends zio.prelude.Subtype[String]
    type SshPublicKeyId = zio.aws.transfer.model.primitives.SshPublicKeyId.Type
    object Status extends zio.prelude.Subtype[String]
    type Status = zio.aws.transfer.model.primitives.Status.Type
    object StatusCode extends zio.prelude.Subtype[Int]
    type StatusCode = zio.aws.transfer.model.primitives.StatusCode.Type
    object StepResultOutputsJson extends zio.prelude.Subtype[String]
    type StepResultOutputsJson =
      zio.aws.transfer.model.primitives.StepResultOutputsJson.Type
    object SubnetId extends zio.prelude.Subtype[String]
    type SubnetId = zio.aws.transfer.model.primitives.SubnetId.Type
    object TagKey extends zio.prelude.Subtype[String]
    type TagKey = zio.aws.transfer.model.primitives.TagKey.Type
    object TagValue extends zio.prelude.Subtype[String]
    type TagValue = zio.aws.transfer.model.primitives.TagValue.Type
    object TransferId extends zio.prelude.Subtype[String]
    type TransferId = zio.aws.transfer.model.primitives.TransferId.Type
    object Url extends zio.prelude.Subtype[String]
    type Url = zio.aws.transfer.model.primitives.Url.Type
    object UserCount extends zio.prelude.Subtype[Int]
    type UserCount = zio.aws.transfer.model.primitives.UserCount.Type
    object UserName extends zio.prelude.Subtype[String]
    type UserName = zio.aws.transfer.model.primitives.UserName.Type
    object UserPassword extends zio.prelude.Subtype[String]
    type UserPassword = zio.aws.transfer.model.primitives.UserPassword.Type
    object VpcEndpointId extends zio.prelude.Subtype[String]
    type VpcEndpointId = zio.aws.transfer.model.primitives.VpcEndpointId.Type
    object VpcId extends zio.prelude.Subtype[String]
    type VpcId = zio.aws.transfer.model.primitives.VpcId.Type
    object WorkflowDescription extends zio.prelude.Subtype[String]
    type WorkflowDescription =
      zio.aws.transfer.model.primitives.WorkflowDescription.Type
    object WorkflowId extends zio.prelude.Subtype[String]
    type WorkflowId = zio.aws.transfer.model.primitives.WorkflowId.Type
    object WorkflowStepName extends zio.prelude.Subtype[String]
    type WorkflowStepName =
      zio.aws.transfer.model.primitives.WorkflowStepName.Type
  }
  type AddressAllocationIds = List[AddressAllocationId]
  type As2Transports = List[zio.aws.transfer.model.As2Transport]
  type CertificateIds = List[CertificateId]
  type ConnectorFileTransferResults =
    List[zio.aws.transfer.model.ConnectorFileTransferResult]
  type ExecutionStepResults = List[zio.aws.transfer.model.ExecutionStepResult]
  type FilePaths = List[FilePath]
  type HomeDirectoryMappings =
    List[zio.aws.transfer.model.HomeDirectoryMapEntry]
  type ListedAccesses = List[zio.aws.transfer.model.ListedAccess]
  type ListedAgreements = List[zio.aws.transfer.model.ListedAgreement]
  type ListedCertificates = List[zio.aws.transfer.model.ListedCertificate]
  type ListedConnectors = List[zio.aws.transfer.model.ListedConnector]
  type ListedExecutions = List[zio.aws.transfer.model.ListedExecution]
  type ListedHostKeys = List[zio.aws.transfer.model.ListedHostKey]
  type ListedProfiles = List[zio.aws.transfer.model.ListedProfile]
  type ListedServers = List[zio.aws.transfer.model.ListedServer]
  type ListedUsers = List[zio.aws.transfer.model.ListedUser]
  type ListedWorkflows = List[zio.aws.transfer.model.ListedWorkflow]
  type OnPartialUploadWorkflowDetails =
    List[zio.aws.transfer.model.WorkflowDetail]
  type OnUploadWorkflowDetails = List[zio.aws.transfer.model.WorkflowDetail]
  type Protocols = List[zio.aws.transfer.model.Protocol]
  type S3Tags = List[zio.aws.transfer.model.S3Tag]
  type SecondaryGids = List[PosixId]
  type SecurityGroupIds = List[SecurityGroupId]
  type SecurityPolicyNames = List[SecurityPolicyName]
  type SecurityPolicyOptions = List[SecurityPolicyOption]
  type SecurityPolicyProtocols =
    List[zio.aws.transfer.model.SecurityPolicyProtocol]
  type ServiceManagedEgressIpAddresses = List[ServiceManagedEgressIpAddress]
  type SftpConnectorTrustedHostKeyList = List[SftpConnectorTrustedHostKey]
  type SshPublicKeys = List[zio.aws.transfer.model.SshPublicKey]
  type StructuredLogDestinations = List[Arn]
  type SubnetIds = List[SubnetId]
  type TagKeys = List[TagKey]
  type Tags = List[zio.aws.transfer.model.Tag]
  type WorkflowSteps = List[zio.aws.transfer.model.WorkflowStep]
}
